/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationResult;
import org.apache.tamaya.model.spi.AbstractModel;

public class ParameterModel
extends AbstractModel {
    private final String regEx;
    private final Class<?> type;

    protected ParameterModel(Builder builder) {
        super(builder.name, builder.required, builder.description, builder.provider);
        this.regEx = builder.regEx;
        this.type = builder.type;
    }

    @Override
    public ModelType getType() {
        return ModelType.Parameter;
    }

    public Class<?> getParameterType() {
        return this.type;
    }

    @Override
    public Collection<ValidationResult> validate(Configuration config) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>(1);
        String configValue = config.get(this.getName());
        if (configValue == null && this.isRequired()) {
            result.add(ValidationResult.ofMissing(this));
        }
        if (configValue != null && this.regEx != null && !configValue.matches(this.regEx)) {
            result.add(ValidationResult.ofError(this, "Config value not matching expression: " + this.regEx + ", was " + configValue));
        }
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append((Object)this.getType()).append(": ").append(this.getName());
        if (this.isRequired()) {
            b.append(", required: ").append(this.isRequired());
        }
        if (this.regEx != null) {
            b.append(", expression: ").append(this.regEx);
        }
        return b.toString();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ConfigModel of(String name, boolean required, String expression) {
        return new Builder(name).setRequired(required).setExpression(expression).build();
    }

    public static ConfigModel of(String name, boolean required) {
        return new Builder(name).setRequired(required).build();
    }

    public static ConfigModel of(String name) {
        return new Builder(name).setRequired(false).build();
    }

    public static class Builder {
        private Class<?> type;
        private String name;
        private String provider;
        private String regEx;
        private String description;
        private boolean required;

        public Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder setType(String type) {
            try {
                this.type = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                try {
                    this.type = Class.forName("java.lang." + type);
                }
                catch (ClassNotFoundException e2) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to load parameter type: " + type, e2);
                }
            }
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setExpression(String expression) {
            this.regEx = expression;
            return this;
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public ConfigModel build() {
            return new ParameterModel(this);
        }
    }
}

