/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.spi.AreaConfigModel;
import org.apache.tamaya.model.spi.ParameterModel;

public final class ConfigModelReader {
    private static final String DEFAULT_META_INFO_SELECTOR = "{model}";
    private static final String META_INFO_SELECTOR_PARAM = "org.apache.tamaya.model.integrated.selector";

    private ConfigModelReader() {
    }

    public static Collection<ConfigModel> loadValidations(Properties props, String defaultProviderName) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> en : props.entrySet()) {
            map.put(en.getKey().toString(), props.getProperty(en.getKey().toString()));
        }
        return ConfigModelReader.loadValidations(map, defaultProviderName);
    }

    public static Collection<ConfigModel> loadValidations(Map<String, String> props, String defaultProviderName) {
        String selector = props.get(META_INFO_SELECTOR_PARAM);
        if (selector == null) {
            selector = DEFAULT_META_INFO_SELECTOR;
        }
        return ConfigModelReader.loadValidations(props, selector, defaultProviderName);
    }

    public static Collection<ConfigModel> loadValidations(Map<String, String> props, String selector, String defaultProviderName) {
        ArrayList<ConfigModel> result = new ArrayList<ConfigModel>();
        String provider = props.get(selector + ".__provider");
        if (provider == null) {
            provider = defaultProviderName;
        }
        HashSet<String> itemKeys = new HashSet<String>();
        for (String key : props.keySet()) {
            if (!key.toString().endsWith(".class")) continue;
            itemKeys.add(key.toString().substring(0, key.toString().length() - ".class".length()));
        }
        for (String baseKey : itemKeys) {
            String clazz = props.get(baseKey + ".class");
            String type = props.get(baseKey + ".type");
            if (type == null) {
                type = String.class.getName();
            }
            String value = props.get(baseKey + ".transitive");
            boolean transitive = false;
            if (value != null) {
                transitive = Boolean.parseBoolean(value);
            }
            String description = props.get(baseKey + ".description");
            String regEx = props.get(baseKey + ".expression");
            String validations = props.get(baseKey + ".validations");
            String requiredVal = props.get(baseKey + ".required");
            if ("Parameter".equalsIgnoreCase(clazz)) {
                result.add(ConfigModelReader.createParameterValidation(baseKey.substring(selector.length() + 1), description, type, requiredVal, regEx, validations, provider));
                continue;
            }
            if (!"Section".equalsIgnoreCase(clazz)) continue;
            if (transitive) {
                result.add(ConfigModelReader.createSectionValidation(baseKey.substring(selector.length() + 1) + ".*", description, requiredVal, validations, provider));
                continue;
            }
            result.add(ConfigModelReader.createSectionValidation(baseKey.substring(selector.length() + 1), description, requiredVal, validations, provider));
        }
        return result;
    }

    private static ConfigModel createParameterValidation(String paramName, String description, String type, String reqVal, String regEx, String validations, String provider) {
        boolean required = "true".equalsIgnoreCase(reqVal);
        ParameterModel.Builder builder = ParameterModel.builder(paramName).setRequired(required).setDescription(description).setExpression(regEx).setType(type).setProvider(provider);
        return builder.build();
    }

    private static ConfigModel createSectionValidation(String sectionName, String description, String reqVal, String validations, String provider) {
        boolean required = "true".equalsIgnoreCase(reqVal);
        AreaConfigModel.Builder builder = AreaConfigModel.builder(sectionName).setRequired(required).setDescription(description).setProvider(provider);
        return builder.build();
    }
}

