/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationResult;

public class ConfigModelGroup
implements ConfigModel {
    private final String name;
    private boolean required;
    private final String provider;
    private List<ConfigModel> childConfigModels = new ArrayList<ConfigModel>();

    public ConfigModelGroup(String name, String provider, ConfigModel ... configModels) {
        this(name, provider, Arrays.asList(configModels));
    }

    public ConfigModelGroup(String name, String provider, Collection<ConfigModel> configModels) {
        this.name = Objects.requireNonNull(name);
        this.provider = provider;
        this.childConfigModels.addAll(configModels);
        this.childConfigModels = Collections.unmodifiableList(this.childConfigModels);
        for (ConfigModel val : configModels) {
            if (!val.isRequired()) continue;
            this.required = true;
            break;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public ModelType getType() {
        return ModelType.Group;
    }

    @Override
    public String getDescription() {
        if (this.childConfigModels.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (ConfigModel val : this.childConfigModels) {
            b.append("  >> ").append(val);
        }
        return b.toString();
    }

    public Collection<ConfigModel> getValidations() {
        return this.childConfigModels;
    }

    @Override
    public Collection<ValidationResult> validate(Configuration config) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>(1);
        for (ConfigModel child : this.childConfigModels) {
            result.addAll(child.validate(config));
        }
        return result;
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + ", size: " + this.childConfigModels.size() + ": " + this.getDescription();
    }
}

