/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationResult;
import org.apache.tamaya.model.spi.ConfigModelGroup;

public class AreaConfigModel
extends ConfigModelGroup {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static ConfigModel of(String name, boolean required) {
        return new Builder(name).setRequired(required).build();
    }

    public static ConfigModel of(String name, boolean required, ConfigModel ... configModels) {
        return new Builder(name).setRequired(required).addValidations(configModels).build();
    }

    protected AreaConfigModel(Builder builder) {
        super(builder.name, builder.provider, builder.childConfigModels);
    }

    @Override
    public ModelType getType() {
        return ModelType.Section;
    }

    @Override
    public Collection<ValidationResult> validate(Configuration config) {
        Map map = config.getProperties();
        String lookupKey = this.getName() + '.';
        boolean present = false;
        for (String key : map.keySet()) {
            if (!key.startsWith(lookupKey)) continue;
            present = true;
            break;
        }
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>(1);
        if (this.isRequired() && !present) {
            result.add(ValidationResult.ofMissing(this));
        }
        result.addAll(super.validate(config));
        return result;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append((Object)this.getType()).append(": ").append(this.getName());
        if (this.isRequired()) {
            b.append(", required: ").append(this.isRequired());
        }
        for (ConfigModel val : this.getValidations()) {
            b.append(", ").append(val.toString());
        }
        return b.toString();
    }

    public static class Builder {
        private String name;
        private String provider;
        private String description;
        private boolean required;
        private final List<ConfigModel> childConfigModels = new ArrayList<ConfigModel>();

        public Builder(String sectionName) {
            this.name = Objects.requireNonNull(sectionName);
        }

        public Builder addValidations(ConfigModel ... configModels) {
            this.childConfigModels.addAll(Arrays.asList(configModels));
            return this;
        }

        public Builder addValidations(Collection<ConfigModel> configModels) {
            this.childConfigModels.addAll(configModels);
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setProvider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public ConfigModel build() {
            return new AreaConfigModel(this);
        }
    }
}

