/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.spi;

import java.util.Objects;
import org.apache.tamaya.model.ConfigModel;

public abstract class AbstractModel
implements ConfigModel,
Comparable<ConfigModel> {
    private final String name;
    private final String provider;
    private final String description;
    private boolean required = false;

    protected AbstractModel(String name, boolean required, String description, String provider) {
        this.name = Objects.requireNonNull(name);
        this.description = description;
        this.required = required;
        this.provider = provider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public int compareTo(ConfigModel configModel) {
        int compare = this.getType().compareTo(configModel.getType());
        if (compare != 0) {
            return compare;
        }
        return this.getName().compareTo(configModel.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModel that = (AbstractModel)o;
        return this.getType().equals((Object)that.getType()) && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.getType().hashCode() + this.name.hashCode();
    }
}

