/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.internal;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.tamaya.events.ConfigEvent;
import org.apache.tamaya.events.ConfigEventListener;
import org.apache.tamaya.inject.spi.ConfiguredField;
import org.apache.tamaya.inject.spi.ConfiguredMethod;
import org.apache.tamaya.inject.spi.ConfiguredType;
import org.apache.tamaya.model.ConfigModelManager;
import org.apache.tamaya.model.internal.ConfiguredTypeEventsModelProvider;
import org.apache.tamaya.model.spi.ParameterModel;

public final class ConfiguredTypeEventsModelPopulator
implements ConfigEventListener {
    private static final Logger LOG = Logger.getLogger(ConfiguredTypeEventsModelPopulator.class.getName());
    private static final String ENABLE_EVENT_DOC = "org.apache.tamaya.model.autoModelEvents";

    public void onConfigEvent(ConfigEvent event) {
        if (event.getResourceType() != ConfiguredType.class) {
            return;
        }
        String value = System.getProperty(ENABLE_EVENT_DOC);
        if (value == null || Boolean.parseBoolean(value)) {
            ParameterModel val;
            Collection keys;
            ConfiguredType confType = (ConfiguredType)event.getResource();
            for (ConfiguredField field : confType.getConfiguredFields()) {
                keys = field.getConfiguredKeys();
                for (String key : keys) {
                    val = ConfigModelManager.getModel(key, ParameterModel.class);
                    if (val != null) continue;
                    ConfiguredTypeEventsModelProvider.addConfigModel(new ParameterModel.Builder(key).setType(field.getType().getName()).setDescription("Injected field: " + field.getAnnotatedField().getDeclaringClass().getName() + '.' + field.toString() + ", \nconfigured with keys: " + keys).build());
                }
            }
            for (ConfiguredMethod method : confType.getConfiguredMethods()) {
                keys = method.getConfiguredKeys();
                for (String key : keys) {
                    val = ConfigModelManager.getModel(key, ParameterModel.class);
                    if (val != null) continue;
                    ConfiguredTypeEventsModelProvider.addConfigModel(new ParameterModel.Builder(key).setType(method.getParameterTypes()[0].getName()).setDescription("Injected field: " + method.getAnnotatedMethod().getDeclaringClass().getName() + '.' + method.toString() + ", \nconfigured with keys: " + keys).build());
                }
            }
        }
    }
}

