/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormats;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.spi.ConfigModelReader;
import org.apache.tamaya.model.spi.ModelProviderSpi;
import org.apache.tamaya.resource.ConfigResources;

public class ConfiguredResourcesModelProviderSpi
implements ModelProviderSpi {
    private static final Logger LOG = Logger.getLogger(ConfiguredResourcesModelProviderSpi.class.getName());
    private static final String MODEL_RESOURCE_PARAM = "org.apache.tamaya.model.resources";
    private static final String CONFIG_RESOURCE_CLASS = "org.apache.tamaya.resource.ConfigResource";
    private static final String CONFIGURATION_FORMATS_CLASS = "org.apache.tamaya.format.ConfigurationFormats";
    private static final boolean AVAILABLE = ConfiguredResourcesModelProviderSpi.checkAvailabilityFormats();
    private static final boolean RESOURCES_EXTENSION_AVAILABLE = ConfiguredResourcesModelProviderSpi.checkAvailabilityResources();
    private List<ConfigModel> configModels = new ArrayList<ConfigModel>();

    private static boolean checkAvailabilityFormats() {
        try {
            Class.forName(CONFIGURATION_FORMATS_CLASS);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkAvailabilityResources() {
        try {
            Class.forName(CONFIG_RESOURCE_CLASS);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ConfiguredResourcesModelProviderSpi() {
        if (!AVAILABLE) {
            LOG.info("tamaya-format extension is required to read model configuration, No extended model support AVAILABLE.");
        } else {
            Collection<URL> urls;
            String resources = ConfigurationProvider.getConfiguration().get(MODEL_RESOURCE_PARAM);
            if (resources == null || resources.trim().isEmpty()) {
                LOG.info("Mo model resources location configured in org.apache.tamaya.model.resources.");
                return;
            }
            if (RESOURCES_EXTENSION_AVAILABLE) {
                LOG.info("Using tamaya-resources extension to read model configuration from " + resources);
                urls = ConfigResources.getResourceResolver().getResources(resources.split(","));
            } else {
                LOG.info("Using default classloader resource location to read model configuration from " + resources);
                urls = new ArrayList();
                for (String resource : resources.split(",")) {
                    if (resource.trim().isEmpty()) continue;
                    try {
                        Enumeration<URL> configs = this.getClass().getClassLoader().getResources(resource);
                        while (configs.hasMoreElements()) {
                            urls.add(configs.nextElement());
                        }
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error evaluating config model locations from " + resource, e);
                    }
                }
            }
            for (URL config : urls) {
                try {
                    InputStream is = config.openStream();
                    Throwable throwable = null;
                    try {
                        ConfigurationData data = ConfigurationFormats.readConfigurationData((URL)config);
                        this.configModels.addAll(ConfigModelReader.loadValidations(data.getCombinedProperties(), config.toString()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error loading config model data from " + config, e);
                }
            }
        }
        this.configModels = Collections.unmodifiableList(this.configModels);
    }

    @Override
    public Collection<ConfigModel> getConfigModels() {
        return this.configModels;
    }
}

