/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.spi.ConfigModelReader;
import org.apache.tamaya.model.spi.ModelProviderSpi;

public class ConfiguredPropertiesModelProviderSpi
implements ModelProviderSpi {
    private static final Logger LOG = Logger.getLogger(ConfiguredPropertiesModelProviderSpi.class.getName());
    private static final String MODEL_EANABLED_PARAM = "org.apache.tamaya.model.default.enabled";
    private List<ConfigModel> configModels = new ArrayList<ConfigModel>();

    public ConfiguredPropertiesModelProviderSpi() {
        boolean enabled;
        String enabledVal = ConfigurationProvider.getConfiguration().get(MODEL_EANABLED_PARAM);
        boolean bl = enabled = enabledVal == null || "true".equalsIgnoreCase(enabledVal);
        if (!enabled) {
            LOG.info("Reading model data from META-INF/configmodel.properties has been disabled.");
            return;
        }
        try {
            LOG.info("Reading model data from META-INF/configmodel.properties...");
            Enumeration<URL> configs = this.getClass().getClassLoader().getResources("META-INF/configmodel.properties");
            while (configs.hasMoreElements()) {
                URL config = configs.nextElement();
                try {
                    InputStream is = config.openStream();
                    Throwable throwable = null;
                    try {
                        Properties props = new Properties();
                        props.load(is);
                        this.configModels.addAll(ConfigModelReader.loadValidations(props, config.toString()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error loading config metadata from " + config, e);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error loading config metadata from META-INF/configmodel.properties", e);
        }
        this.configModels = Collections.unmodifiableList(this.configModels);
    }

    @Override
    public Collection<ConfigModel> getConfigModels() {
        return this.configModels;
    }
}

