/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ConfigModelManager;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationResult;
import org.apache.tamaya.model.spi.ConfigDocumentationMBean;

public class ConfigDocumentationBean
implements ConfigDocumentationMBean {
    private final JsonWriterFactory writerFactory;
    private static final Comparator<ValidationResult> COMPARATOR = new Comparator<ValidationResult>(){

        @Override
        public int compare(ValidationResult v1, ValidationResult v2) {
            int compare = VAL_COMPARATOR.compare(v1.getConfigModel(), v2.getConfigModel());
            if (compare == 0) {
                compare = v1.getResult().compareTo(v2.getResult());
            }
            if (compare == 0) {
                return v1.getMessage().compareTo(v2.getMessage());
            }
            return compare;
        }
    };
    private static final Comparator<ConfigModel> VAL_COMPARATOR = new Comparator<ConfigModel>(){

        @Override
        public int compare(ConfigModel v1, ConfigModel v2) {
            int compare = v1.getType().compareTo(v2.getType());
            if (compare == 0) {
                compare = v1.getName().compareTo(v2.getName());
            }
            return compare;
        }
    };
    private Configuration config;

    public ConfigDocumentationBean() {
        this(null);
    }

    public ConfigDocumentationBean(Configuration config) {
        this.config = config;
        HashMap<String, Boolean> writerProperties = new HashMap<String, Boolean>(1);
        writerProperties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        this.writerFactory = Json.createWriterFactory(writerProperties);
    }

    private Configuration getConfig() {
        return this.config != null ? this.config : ConfigurationProvider.getConfiguration();
    }

    @Override
    public String validate(boolean showUndefined) {
        ArrayList<ValidationResult> validations = new ArrayList<ValidationResult>(ConfigModelManager.validate(this.getConfig(), showUndefined));
        Collections.sort(validations, COMPARATOR);
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (ValidationResult val : validations) {
            builder.add((JsonValue)this.toJsonObject(val));
        }
        return this.formatJson(builder.build());
    }

    @Override
    public String getConfigurationModel() {
        ArrayList<ConfigModel> configModels = new ArrayList<ConfigModel>(ConfigModelManager.getModels());
        Collections.sort(configModels, VAL_COMPARATOR);
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (ConfigModel val : configModels) {
            result.add((JsonValue)this.toJsonObject(val));
        }
        return this.formatJson(result.build());
    }

    @Override
    public String getConfigurationModel(ModelType type) {
        return this.findValidationModels(type, ".*");
    }

    @Override
    public String findConfigurationModels(String namePattern) {
        ArrayList<ConfigModel> configModels = new ArrayList<ConfigModel>(ConfigModelManager.findModels(namePattern));
        Collections.sort(configModels, VAL_COMPARATOR);
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (ConfigModel val : configModels) {
            result.add((JsonValue)this.toJsonObject(val));
        }
        return this.formatJson(result.build());
    }

    @Override
    public String findValidationModels(ModelType type, String namePattern) {
        ArrayList<ConfigModel> configModels = new ArrayList<ConfigModel>(ConfigModelManager.findModels(type, namePattern));
        Collections.sort(configModels, VAL_COMPARATOR);
        JsonArrayBuilder result = Json.createArrayBuilder();
        for (ConfigModel val : configModels) {
            result.add((JsonValue)this.toJsonObject(val));
        }
        return this.formatJson(result.build());
    }

    public String toString() {
        return "ConfigDocumentationBean, config: " + (this.config != null ? this.config.toString() : "<current>");
    }

    private JsonObject toJsonObject(ConfigModel val) {
        JsonObjectBuilder valJson = Json.createObjectBuilder().add("type", val.getType().toString()).add("name", val.getName());
        if (val.getDescription() != null) {
            valJson.add("description", val.getDescription());
        }
        if (val.isRequired()) {
            valJson.add("required", true);
        }
        return valJson.build();
    }

    private JsonObject toJsonObject(ValidationResult val) {
        JsonObjectBuilder valJson = Json.createObjectBuilder().add("type", val.getConfigModel().getType().toString()).add("name", val.getConfigModel().getName());
        if (val.getConfigModel().isRequired()) {
            valJson.add("required", true);
        }
        if (val.getConfigModel().getDescription() != null) {
            valJson.add("description", val.getConfigModel().getDescription());
        }
        valJson.add("result", val.getResult().toString());
        if (val.getMessage() != null) {
            valJson.add("message", val.getMessage());
        }
        return valJson.build();
    }

    private String formatJson(JsonArray data) {
        StringWriter writer = new StringWriter();
        JsonWriter gen = this.writerFactory.createWriter((Writer)writer);
        gen.writeArray(data);
        return writer.toString();
    }
}

