/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationState;
import org.apache.tamaya.model.spi.AbstractModel;

public final class ValidationResult {
    private final ConfigModel configModel;
    private final ValidationState result;
    private final String message;

    public static ValidationResult ofValid(ConfigModel configModel) {
        return new ValidationResult(configModel, ValidationState.VALID, null);
    }

    public static ValidationResult ofMissing(ConfigModel configModel) {
        return new ValidationResult(configModel, ValidationState.MISSING, null);
    }

    public static ValidationResult ofMissing(ConfigModel configModel, String message) {
        return new ValidationResult(configModel, ValidationState.MISSING, message);
    }

    public static ValidationResult ofError(ConfigModel configModel, String error) {
        return new ValidationResult(configModel, ValidationState.ERROR, error);
    }

    public static ValidationResult ofWarning(ConfigModel configModel, String warning) {
        return new ValidationResult(configModel, ValidationState.WARNING, warning);
    }

    public static ValidationResult ofDeprecated(ConfigModel configModel, String alternativeUsage) {
        return new ValidationResult(configModel, ValidationState.DEPRECATED, alternativeUsage != null ? "Use instead: " + alternativeUsage : null);
    }

    public static ValidationResult ofDeprecated(ConfigModel configModel) {
        return new ValidationResult(configModel, ValidationState.DEPRECATED, null);
    }

    public static ValidationResult ofUndefined(String key, final ModelType type, String provider) {
        return new ValidationResult(new AbstractModel(key, false, "Undefined key: " + key, provider){

            @Override
            public ModelType getType() {
                return type;
            }

            @Override
            public Collection<ValidationResult> validate(Configuration config) {
                return Collections.emptySet();
            }
        }, ValidationState.UNDEFINED, null);
    }

    public static ValidationResult of(ConfigModel configModel, ValidationState result, String message) {
        return new ValidationResult(configModel, result, message);
    }

    private ValidationResult(ConfigModel configModel, ValidationState result, String message) {
        this.message = message;
        this.configModel = Objects.requireNonNull(configModel);
        this.result = Objects.requireNonNull(result);
    }

    public ConfigModel getConfigModel() {
        return this.configModel;
    }

    public ValidationState getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.message != null) {
            return (Object)((Object)this.result) + ": " + this.configModel.getName() + " (" + (Object)((Object)this.configModel.getType()) + ") -> " + this.message + '\n';
        }
        return (Object)((Object)this.result) + ": " + this.configModel.getName() + " (" + (Object)((Object)this.configModel.getType()) + ")";
    }
}

