/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.model;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.model.ConfigModel;
import org.apache.tamaya.model.ModelType;
import org.apache.tamaya.model.ValidationResult;
import org.apache.tamaya.model.spi.ConfigDocumentationMBean;
import org.apache.tamaya.model.spi.ModelProviderSpi;
import org.apache.tamaya.spi.ServiceContextManager;

public final class ConfigModelManager {
    private static final Logger LOG = Logger.getLogger(ConfigModelManager.class.getName());

    private ConfigModelManager() {
    }

    public static Collection<ConfigModel> getModels() {
        ArrayList<ConfigModel> result = new ArrayList<ConfigModel>();
        for (ModelProviderSpi model : ServiceContextManager.getServiceContext().getServices(ModelProviderSpi.class)) {
            result.addAll(model.getConfigModels());
        }
        return result;
    }

    public static Collection<ConfigModel> findModels(ModelType type, String namePattern) {
        ArrayList<ConfigModel> result = new ArrayList<ConfigModel>();
        for (ModelProviderSpi model : ServiceContextManager.getServiceContext().getServices(ModelProviderSpi.class)) {
            for (ConfigModel configModel : model.getConfigModels()) {
                if (!configModel.getName().matches(namePattern) || configModel.getType() != type) continue;
                result.add(configModel);
            }
        }
        return result;
    }

    public static <T extends ConfigModel> T getModel(String name, Class<T> modelType) {
        for (ModelProviderSpi model : ServiceContextManager.getServiceContext().getServices(ModelProviderSpi.class)) {
            for (ConfigModel configModel : model.getConfigModels()) {
                if (!configModel.getName().equals(name) || !configModel.getClass().equals(modelType)) continue;
                return (T)((ConfigModel)modelType.cast(configModel));
            }
        }
        return null;
    }

    public static Collection<ConfigModel> findModels(String namePattern) {
        ArrayList<ConfigModel> result = new ArrayList<ConfigModel>();
        for (ModelProviderSpi model : ServiceContextManager.getServiceContext().getServices(ModelProviderSpi.class)) {
            for (ConfigModel configModel : model.getConfigModels()) {
                if (!configModel.getName().matches(namePattern)) continue;
                result.add(configModel);
            }
        }
        return result;
    }

    public static Collection<ValidationResult> validate() {
        return ConfigModelManager.validate(false);
    }

    public static Collection<ValidationResult> validate(boolean showUndefined) {
        return ConfigModelManager.validate(ConfigurationProvider.getConfiguration(), showUndefined);
    }

    public static Collection<ValidationResult> validate(Configuration config) {
        return ConfigModelManager.validate(config, false);
    }

    public static Collection<ValidationResult> validate(Configuration config, boolean showUndefined) {
        ArrayList<ValidationResult> result = new ArrayList<ValidationResult>();
        for (ConfigModel defConf : ConfigModelManager.getModels()) {
            result.addAll(defConf.validate(config));
        }
        if (showUndefined) {
            HashMap map = new HashMap(config.getProperties());
            Set<String> areas = ConfigModelManager.extractTransitiveAreas(map.keySet());
            for (ConfigModel configModel : ConfigModelManager.getModels()) {
                if (ModelType.Section.equals((Object)configModel.getType())) {
                    Iterator<String> iter = areas.iterator();
                    while (iter.hasNext()) {
                        String area = iter.next();
                        if (!area.matches(configModel.getName())) continue;
                        iter.remove();
                    }
                }
                if (!ModelType.Parameter.equals((Object)configModel.getType())) continue;
                map.remove(configModel.getName());
            }
            block3: for (Map.Entry entry : map.entrySet()) {
                for (ConfigModel defConf : ConfigModelManager.getModels()) {
                    if (!ModelType.Section.equals((Object)defConf.getType()) || !defConf.getName().endsWith(".*") || !((String)entry.getKey()).matches(defConf.getName())) continue;
                    continue block3;
                }
                result.add(ValidationResult.ofUndefined((String)entry.getKey(), ModelType.Parameter, null));
            }
            for (String string : areas) {
                result.add(ValidationResult.ofUndefined(string, ModelType.Section, null));
            }
        }
        return result;
    }

    private static Set<String> extractTransitiveAreas(Set<String> keys) {
        HashSet<String> transitiveClosure = new HashSet<String>();
        for (String key : keys) {
            int index = key.lastIndexOf(46);
            while (index > 0) {
                String areaKey = key.substring(0, index);
                transitiveClosure.add(areaKey);
                index = areaKey.lastIndexOf(46);
            }
        }
        return transitiveClosure;
    }

    public static void registerMBean() {
        ConfigModelManager.registerMBean(null);
    }

    public static void registerMBean(String context) {
        try {
            ConfigDocumentationMBean configMbean = (ConfigDocumentationMBean)ServiceContextManager.getServiceContext().getService(ConfigDocumentationMBean.class);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = context == null ? new ObjectName("org.apache.tamaya.model:type=ConfigDocumentationMBean") : new ObjectName("org.apache.tamaya.model:type=ConfigDocumentationMBean,context=" + context);
            try {
                mbs.getMBeanInfo(on);
                LOG.warning("Cannot register mbean " + on + ": already existing.");
            }
            catch (InstanceNotFoundException e) {
                LOG.info("Registering mbean " + on + "...");
                mbs.registerMBean(configMbean, on);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to register ConfigDocumentationMBean.", e);
        }
    }
}

