/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.apache.tamaya.inject.ConfigurationInjection;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;

@Vetoed
public final class SEInjectorCDIExtension
implements Extension {
    public <T> void initializeConfiguredFields(@Observes ProcessInjectionTarget<T> pit) {
        AnnotatedType at = pit.getAnnotatedType();
        if (!this.isConfigured(at.getJavaClass())) {
            return;
        }
        final InjectionTarget it = pit.getInjectionTarget();
        InjectionTarget wrapped = new InjectionTarget<T>(){

            public void inject(T instance, CreationalContext<T> ctx) {
                it.inject(instance, ctx);
                ConfigurationInjection.getConfigurationInjector().configure(instance);
            }

            public void postConstruct(T instance) {
                it.postConstruct(instance);
            }

            public void preDestroy(T instance) {
                it.dispose(instance);
            }

            public void dispose(T instance) {
                it.dispose(instance);
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public T produce(CreationalContext<T> ctx) {
                return it.produce(ctx);
            }
        };
        pit.setInjectionTarget(wrapped);
    }

    private boolean isConfigured(Class type) {
        if (type.getAnnotation(ConfigDefaultSections.class) != null) {
            return true;
        }
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Config.class)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(Config.class)) continue;
            return true;
        }
        return false;
    }
}

