/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi.internal;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.clsupport.CLAwareServiceContext;
import org.apache.tamaya.integration.cdi.internal.TamayaCDIIntegration;
import org.apache.tamaya.spi.ServiceContext;

public class CDIAwareServiceContext
implements ServiceContext {
    private final CLAwareServiceContext clAwareServiceContext = new CLAwareServiceContext();
    private final Map<Class<?>, Object> singletons = new ConcurrentHashMap();

    public <T> T getService(Class<T> serviceType) {
        List<T> services;
        Object cached = this.singletons.get(serviceType);
        if (cached == null && (cached = (services = this.getServices(serviceType)).isEmpty() ? null : this.getServiceWithHighestPriority(services, serviceType)) != null) {
            this.singletons.put(serviceType, cached);
        }
        return serviceType.cast(cached);
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        List found = this.clAwareServiceContext.getServices(serviceType);
        BeanManager beanManager = TamayaCDIIntegration.getBeanManager();
        Instance cdiInstances = null;
        if (beanManager != null) {
            Set instanceBeans = beanManager.getBeans(Instance.class, new Annotation[0]);
            cdiInstances = (Instance)beanManager.getReference((Bean)instanceBeans.iterator().next(), Instance.class, null);
        }
        if (cdiInstances != null) {
            for (Object t : cdiInstances.select(serviceType, new Annotation[0])) {
                found.add(t);
            }
        }
        return found;
    }

    public static int getPriority(Object o) {
        int prio = 1;
        Priority priority = o.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            prio = priority.value();
        }
        return prio;
    }

    private <T> T getServiceWithHighestPriority(Collection<T> services, Class<T> serviceType) {
        if (services.size() == 1) {
            return services.iterator().next();
        }
        Integer highestPriority = null;
        int highestPriorityServiceCount = 0;
        T highestService = null;
        for (T service : services) {
            int prio = CDIAwareServiceContext.getPriority(service);
            if (highestPriority == null || highestPriority < prio) {
                highestService = service;
                highestPriorityServiceCount = 1;
                highestPriority = prio;
                continue;
            }
            if (highestPriority != prio) continue;
            ++highestPriorityServiceCount;
        }
        if (highestPriorityServiceCount > 1) {
            throw new ConfigException(MessageFormat.format("Found {0} implementations for Service {1} with Priority {2}: {3}", highestPriorityServiceCount, serviceType.getName(), highestPriority, services));
        }
        return highestService;
    }

    public int ordinal() {
        return 20;
    }
}

