/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.collections.internal.ItemTokenizer;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class TreeSetConverter
implements PropertyConverter<TreeSet> {
    private static final Logger LOG = Logger.getLogger(TreeSetConverter.class.getName());
    private static final TreeSetConverter INSTANCE = new TreeSetConverter();

    static TreeSetConverter getInstance() {
        return INSTANCE;
    }

    public TreeSet convert(String value, ConversionContext context) {
        List<String> rawList = ItemTokenizer.split(value, context);
        TreeSet<Object> result = new TreeSet<Object>();
        for (String raw : rawList) {
            String[] items = ItemTokenizer.splitMapEntry(raw, context);
            Object convValue = ItemTokenizer.convertValue(items[1], context);
            if (convValue != null) {
                result.add(convValue);
                continue;
            }
            LOG.log(Level.SEVERE, "Failed to convert collection value type for '" + raw + "'.");
        }
        return result;
    }
}

