/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Set;
import org.apache.tamaya.collections.internal.HashSetConverter;
import org.apache.tamaya.collections.internal.TreeSetConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class SetConverter
implements PropertyConverter<Set> {
    public Set convert(String value, ConversionContext context) {
        String collectionType = context.getConfiguration().getOrDefault('_' + context.getKey() + ".collection-type", "Set");
        if (collectionType.startsWith("java.util.")) {
            collectionType = collectionType.substring("java.util.".length());
        }
        AbstractSet result = null;
        switch (collectionType) {
            case "TreeSet": {
                result = TreeSetConverter.getInstance().convert(value, context);
                break;
            }
            default: {
                result = HashSetConverter.getInstance().convert(value, context);
            }
        }
        if (((Boolean)context.getConfiguration().getOrDefault('_' + context.getKey() + ".read-only", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            return Collections.unmodifiableSet(result);
        }
        return result;
    }
}

