/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import org.apache.tamaya.collections.internal.ConcurrentHashMapConverter;
import org.apache.tamaya.collections.internal.HashMapConverter;
import org.apache.tamaya.collections.internal.TreeMapConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class MapConverter
implements PropertyConverter<Map> {
    public Map convert(String value, ConversionContext context) {
        String collectionType = context.getConfiguration().getOrDefault('_' + context.getKey() + ".collection-type", "Map");
        if (collectionType.startsWith("java.util.")) {
            collectionType = collectionType.substring("java.util.".length());
        }
        AbstractMap result = null;
        switch (collectionType) {
            case "TreeMap": {
                result = TreeMapConverter.getInstance().convert(value, context);
                break;
            }
            case "ConcurrentHashMap": {
                result = ConcurrentHashMapConverter.getInstance().convert(value, context);
                break;
            }
            default: {
                result = HashMapConverter.getInstance().convert(value, context);
            }
        }
        if (((Boolean)context.getConfiguration().getOrDefault('_' + context.getKey() + ".read-only", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            return Collections.unmodifiableMap(result);
        }
        return result;
    }
}

