/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.apache.tamaya.collections.internal.ArrayListConverter;
import org.apache.tamaya.collections.internal.LinkedListConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class ListConverter
implements PropertyConverter<List> {
    public List convert(String value, ConversionContext context) {
        String collectionType = context.getConfiguration().getOrDefault('_' + context.getKey() + ".collection-type", "List");
        if (collectionType.startsWith("java.util.")) {
            collectionType = collectionType.substring("java.util.".length());
        }
        AbstractList result = null;
        switch (collectionType) {
            case "LinkedList": {
                result = LinkedListConverter.getInstance().convert(value, context);
                break;
            }
            default: {
                result = ArrayListConverter.getInstance().convert(value, context);
            }
        }
        if (((Boolean)context.getConfiguration().getOrDefault('_' + context.getKey() + ".read-only", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            return Collections.unmodifiableList(result);
        }
        return result;
    }
}

