/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

final class ItemTokenizer {
    private static final Logger LOG = Logger.getLogger(ItemTokenizer.class.getName());

    private ItemTokenizer() {
    }

    public static List<String> split(String value, ConversionContext context) {
        return ItemTokenizer.split(value, ConfigurationProvider.getConfiguration().getOrDefault('_' + context.getKey() + "" + "item-separator", ","));
    }

    public static List<String> split(String value, String separator) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int end = value.indexOf(separator, start);
        while (end > 0) {
            if (value.charAt(end - 1) != '\\') {
                result.add(value.substring(start, end));
                start = end + separator.length();
                end = value.indexOf(separator, start);
            } else {
                end = value.indexOf(separator, end + separator.length());
            }
            end = value.indexOf(separator, start);
        }
        if (start < value.length()) {
            result.add(value.substring(start));
        }
        return result;
    }

    public static String[] splitMapEntry(String mapEntry, ConversionContext context) {
        return ItemTokenizer.splitMapEntry(mapEntry, ConfigurationProvider.getConfiguration().getOrDefault('_' + context.getKey() + ".map-entry-separator", "::"));
    }

    public static String[] splitMapEntry(String mapEntry, String separator) {
        int index = mapEntry.indexOf(separator);
        String[] items = index < 0 ? new String[]{mapEntry, mapEntry} : new String[]{mapEntry.substring(0, index), mapEntry.substring(index + separator.length())};
        if (items[0].trim().startsWith("[")) {
            items[0] = items[0].trim();
            items[0] = items[0].substring(1);
        } else {
            items[0] = items[0].trim();
        }
        items[1] = items[1].trim().endsWith("]") ? items[1].substring(0, items[1].length() - 1) : items[1].trim();
        return items;
    }

    public static Object convertValue(String value, ConversionContext context) {
        String converterClass = context.getConfiguration().get('_' + context.getKey() + ".item-converter");
        ArrayList<PropertyConverter> valueConverters = new ArrayList<PropertyConverter>(1);
        if (converterClass != null) {
            try {
                valueConverters.add((PropertyConverter)Class.forName(converterClass).newInstance());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error convertion config to ArrayList type.", e);
            }
        }
        if (TypeLiteral.getTypeParameters((Type)context.getTargetType().getType()).length > 0) {
            valueConverters.addAll(context.getConfigurationContext().getPropertyConverters(TypeLiteral.of((Type)TypeLiteral.getTypeParameters((Type)context.getTargetType().getType())[0])));
        }
        ConversionContext ctx = new ConversionContext.Builder(context.getConfiguration(), context.getConfigurationContext(), context.getKey(), TypeLiteral.of((Type)context.getTargetType().getType())).build();
        Object result = null;
        if (valueConverters.isEmpty()) {
            return value;
        }
        for (PropertyConverter conv : valueConverters) {
            try {
                result = conv.convert(value, ctx);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error convertion config to ArrayList type.", e);
            }
        }
        LOG.log(Level.SEVERE, "Failed to convert collection value type for '" + value + "'.");
        return null;
    }
}

