/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.collections.internal.ItemTokenizer;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class HashSetConverter
implements PropertyConverter<HashSet> {
    private static final Logger LOG = Logger.getLogger(HashSetConverter.class.getName());
    private static final HashSetConverter INSTANCE = new HashSetConverter();

    static HashSetConverter getInstance() {
        return INSTANCE;
    }

    public HashSet convert(String value, ConversionContext context) {
        List<String> rawList = ItemTokenizer.split(value, context);
        HashSet<Object> result = new HashSet<Object>();
        for (String raw : rawList) {
            String[] items = ItemTokenizer.splitMapEntry(raw, context);
            Object convValue = ItemTokenizer.convertValue(items[1], context);
            if (convValue != null) {
                result.add(convValue);
                continue;
            }
            LOG.log(Level.SEVERE, "Failed to convert collection value type for '" + raw + "'.");
        }
        return result;
    }
}

