/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.collections.internal.ItemTokenizer;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class ConcurrentHashMapConverter
implements PropertyConverter<ConcurrentHashMap> {
    private static final Logger LOG = Logger.getLogger(ConcurrentHashMapConverter.class.getName());
    private static final ConcurrentHashMapConverter INSTANCE = new ConcurrentHashMapConverter();

    static ConcurrentHashMapConverter getInstance() {
        return INSTANCE;
    }

    public ConcurrentHashMap convert(String value, ConversionContext context) {
        List<String> rawList = ItemTokenizer.split(value, context);
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(rawList.size());
        for (String raw : rawList) {
            String[] items = ItemTokenizer.splitMapEntry(raw, context);
            Object convValue = ItemTokenizer.convertValue(items[1], context);
            if (convValue != null) {
                result.put(items[0], convValue);
                continue;
            }
            LOG.log(Level.SEVERE, "Failed to convert collection value type for '" + raw + "'.");
        }
        return result;
    }
}

