/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import org.apache.tamaya.collections.internal.ArrayListConverter;
import org.apache.tamaya.collections.internal.HashSetConverter;
import org.apache.tamaya.collections.internal.LinkedListConverter;
import org.apache.tamaya.collections.internal.TreeSetConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class CollectionConverter
implements PropertyConverter<Collection> {
    public Collection convert(String value, ConversionContext context) {
        String collectionType = context.getConfiguration().getOrDefault('_' + context.getKey() + ".collection-type", "List");
        if (collectionType.startsWith("java.util.")) {
            collectionType = collectionType.substring("java.util.".length());
        }
        AbstractCollection result = null;
        switch (collectionType) {
            case "LinkedList": {
                result = LinkedListConverter.getInstance().convert(value, context);
                break;
            }
            case "Set": 
            case "HashSet": {
                result = HashSetConverter.getInstance().convert(value, context);
                break;
            }
            case "SortedSet": 
            case "TreeSet": {
                result = TreeSetConverter.getInstance().convert(value, context);
                break;
            }
            default: {
                result = ArrayListConverter.getInstance().convert(value, context);
            }
        }
        if (((Boolean)context.getConfiguration().getOrDefault('_' + context.getKey() + ".read-only", Boolean.class, (Object)Boolean.TRUE)).booleanValue()) {
            return Collections.unmodifiableCollection(result);
        }
        return result;
    }
}

