/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.collections.internal.ItemTokenizer;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class ArrayListConverter
implements PropertyConverter<ArrayList> {
    private static final Logger LOG = Logger.getLogger(ArrayListConverter.class.getName());
    private static final ArrayListConverter INSTANCE = new ArrayListConverter();

    static ArrayListConverter getInstance() {
        return INSTANCE;
    }

    public ArrayList convert(String value, ConversionContext context) {
        List<String> rawList = ItemTokenizer.split(value, context);
        ArrayList<Object> mlist = new ArrayList<Object>();
        for (String raw : rawList) {
            Object convValue = ItemTokenizer.convertValue(raw, context);
            if (convValue != null) {
                mlist.add(convValue);
                continue;
            }
            LOG.log(Level.SEVERE, "Failed to convert collection value type for '" + raw + "'.");
        }
        return mlist;
    }
}

