/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.collections.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

@Priority(value=100)
public class AdaptiveCombinationPolicy
implements PropertyValueCombinationPolicy {
    private static final Logger LOG = Logger.getLogger(AdaptiveCombinationPolicy.class.getName());
    private static final PropertyValueCombinationPolicy COLLECTING_POLICY = new PropertyValueCombinationPolicy(){

        public Map<String, String> collect(Map<String, String> currentValue, String key, PropertySource propertySource) {
            String separator = ConfigurationProvider.getConfiguration().getOrDefault('_' + key + ".item-separator", ",");
            PropertyValue newValue = propertySource.get(key);
            if (newValue != null) {
                HashMap<String, String> newMapValue = new HashMap<String, String>();
                if (currentValue != null) {
                    newMapValue.putAll(currentValue);
                }
                String oldVal = (String)newMapValue.get(key);
                newMapValue.putAll(newValue.getConfigEntries());
                if (oldVal != null) {
                    newMapValue.put(key, oldVal + separator + newValue.getValue());
                }
                return newMapValue;
            }
            if (currentValue != null) {
                return currentValue;
            }
            return Collections.emptyMap();
        }
    };
    private Map<Class, PropertyValueCombinationPolicy> configuredPolicies = new ConcurrentHashMap<Class, PropertyValueCombinationPolicy>();

    public Map<String, String> collect(Map<String, String> currentValue, String key, PropertySource propertySource) {
        if (key.startsWith("_")) {
            PropertyValue newValue = propertySource.get(key);
            if (newValue != null) {
                return newValue.getConfigEntries();
            }
            return currentValue;
        }
        String adaptiveCombinationPolicyClass = ConfigurationProvider.getConfiguration().getOrDefault('_' + key + ".combination-policy", "override");
        PropertyValueCombinationPolicy combinationPolicy = null;
        switch (adaptiveCombinationPolicyClass) {
            case "collect": 
            case "COLLECT": {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Using collecting combination policy for key: " + key + "");
                }
                combinationPolicy = COLLECTING_POLICY;
                break;
            }
            case "override": 
            case "OVERRIDE": {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Using default (overriding) combination policy for key: " + key + "");
                }
                combinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
                break;
            }
            default: {
                try {
                    Class<?> clazz = Class.forName(adaptiveCombinationPolicyClass);
                    combinationPolicy = this.configuredPolicies.get(clazz);
                    if (combinationPolicy == null) {
                        combinationPolicy = (PropertyValueCombinationPolicy)clazz.newInstance();
                        this.configuredPolicies.put(clazz, combinationPolicy);
                    }
                    if (!LOG.isLoggable(Level.FINEST)) break;
                    LOG.finest("Using custom combination policy " + adaptiveCombinationPolicyClass + " for " + "key: " + key + "");
                    break;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error loading configured PropertyValueCombinationPolicy for key: " + key + ", using default (overriding) policy.", e);
                    combinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
                }
            }
        }
        return combinationPolicy.collect(currentValue, key, propertySource);
    }
}

