/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.json.JSONVisitor;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public class JSONPropertySource
implements PropertySource {
    public static final String JOHNZON_SUPPORTS_COMMENTS_PROP = "org.apache.johnzon.supports-comments";
    private final URL urlResource;
    private final Map<String, String> values;
    private int ordinal;
    private JsonReaderFactory readerFactory = this.initReaderFactory();

    private JsonReaderFactory initReaderFactory() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put(JOHNZON_SUPPORTS_COMMENTS_PROP, true);
        return Json.createReaderFactory(config);
    }

    public JSONPropertySource(URL resource) {
        this(resource, 0);
    }

    public JSONPropertySource(URL resource, int defaultOrdinal) {
        this.urlResource = Objects.requireNonNull(resource);
        this.ordinal = defaultOrdinal;
        this.values = this.readConfig(this.urlResource);
        if (this.values.containsKey("tamaya.ordinal")) {
            this.ordinal = Integer.parseInt(this.values.get("tamaya.ordinal"));
        }
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put(JOHNZON_SUPPORTS_COMMENTS_PROP, true);
        this.readerFactory = Json.createReaderFactory(config);
    }

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.ordinal;
    }

    public String getName() {
        return this.urlResource.toExternalForm();
    }

    public PropertyValue get(String key) {
        return PropertyValue.of((String)key, (String)this.getProperties().get(key), (String)this.getName());
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.values);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, String> readConfig(URL urlResource) {
        try (InputStream is = urlResource.openStream();){
            JsonStructure root = this.readerFactory.createReader(is, Charset.forName("UTF-8")).read();
            if (!(root instanceof JsonObject)) {
                throw new ConfigException("Currently only JSON objects are supported");
            }
            HashMap<String, String> values = new HashMap<String, String>();
            JSONVisitor visitor = new JSONVisitor((JsonObject)root, values);
            visitor.run();
            HashMap<String, String> hashMap = values;
            return hashMap;
        }
        catch (Throwable t) {
            throw new ConfigException(String.format("Failed to read properties from %s", urlResource.toExternalForm()), t);
        }
    }

    public boolean isScannable() {
        return true;
    }
}

