/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.json;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationDataBuilder;
import org.apache.tamaya.format.ConfigurationFormat;
import org.apache.tamaya.json.JSONVisitor;

public class JSONFormat
implements ConfigurationFormat {
    public static final String JOHNZON_SUPPORTS_COMMENTS_PROP = "org.apache.johnzon.supports-comments";
    private final JsonReaderFactory readerFactory;

    public JSONFormat() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put(JOHNZON_SUPPORTS_COMMENTS_PROP, true);
        this.readerFactory = Json.createReaderFactory(config);
    }

    public String getName() {
        return "json";
    }

    public boolean accepts(URL url) {
        return Objects.requireNonNull(url).getPath().endsWith(".json");
    }

    public ConfigurationData readConfiguration(String resource, InputStream inputStream) {
        try {
            JsonReader reader = this.readerFactory.createReader(inputStream, Charset.forName("UTF-8"));
            JsonObject root = reader.readObject();
            HashMap<String, String> values = new HashMap<String, String>();
            JSONVisitor visitor = new JSONVisitor(root, values);
            visitor.run();
            return ConfigurationDataBuilder.of((String)resource, (ConfigurationFormat)this).addProperties(values).build();
        }
        catch (JsonException e) {
            throw new ConfigException("Failed to read data from " + resource, (Throwable)e);
        }
    }
}

