/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.api.BaseDynamicValue;
import org.apache.tamaya.inject.api.DynamicValue;
import org.apache.tamaya.inject.api.InjectionUtils;
import org.apache.tamaya.inject.api.LoadPolicy;
import org.apache.tamaya.inject.api.UpdatePolicy;
import org.apache.tamaya.inject.api.WithPropertyConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

final class DefaultDynamicValue<T>
extends BaseDynamicValue<T> {
    private static final long serialVersionUID = -2071172847144537443L;
    private final String propertyName;
    private final String[] keys;
    private final Configuration configuration;
    private final TypeLiteral<T> targetType;
    private final PropertyConverter<T> propertyConverter;
    private UpdatePolicy updatePolicy;
    private final LoadPolicy loadPolicy;
    private transient T value;
    private transient Object[] newValue;
    private transient WeakList<PropertyChangeListener> listeners;

    private DefaultDynamicValue(String propertyName, Configuration configuration, TypeLiteral<T> targetType, PropertyConverter<T> propertyConverter, List<String> keys, LoadPolicy loadPolicy, UpdatePolicy updatePolicy) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.keys = keys.toArray(new String[keys.size()]);
        this.configuration = Objects.requireNonNull(configuration);
        this.propertyConverter = propertyConverter;
        this.targetType = targetType;
        this.loadPolicy = Objects.requireNonNull(loadPolicy);
        this.updatePolicy = Objects.requireNonNull(updatePolicy);
        if (loadPolicy == LoadPolicy.INITIAL) {
            this.value = this.evaluateValue();
        }
    }

    public static DynamicValue of(Field annotatedField, Configuration configuration) {
        return DefaultDynamicValue.of(annotatedField, configuration, LoadPolicy.ALWAYS, UpdatePolicy.IMMEDEATE);
    }

    public static DynamicValue of(Field annotatedField, Configuration configuration, LoadPolicy loadPolicy) {
        return DefaultDynamicValue.of(annotatedField, configuration, loadPolicy, UpdatePolicy.IMMEDEATE);
    }

    public static DynamicValue of(Field annotatedField, Configuration configuration, UpdatePolicy updatePolicy) {
        return DefaultDynamicValue.of(annotatedField, configuration, LoadPolicy.ALWAYS, updatePolicy);
    }

    public static DynamicValue of(Field annotatedField, Configuration configuration, LoadPolicy loadPolicy, UpdatePolicy updatePolicy) {
        Type targetType = annotatedField.getGenericType();
        if (targetType == null) {
            throw new ConfigException("Failed to evaluate target type for " + annotatedField.getDeclaringClass().getName() + '.' + annotatedField.getName());
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)targetType;
            Type[] types = pt.getActualTypeArguments();
            if (types.length != 1) {
                throw new ConfigException("Failed to evaluate target type for " + annotatedField.getDeclaringClass().getName() + '.' + annotatedField.getName());
            }
            targetType = types[0];
        }
        PropertyConverter propertyConverter = null;
        WithPropertyConverter annot = annotatedField.getAnnotation(WithPropertyConverter.class);
        if (annot != null) {
            try {
                propertyConverter = (PropertyConverter)annot.value().newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Failed to instantiate annotated PropertyConverter on " + annotatedField.getDeclaringClass().getName() + '.' + annotatedField.getName(), (Throwable)e);
            }
        }
        List keys = InjectionUtils.getKeys((Field)annotatedField);
        return new DefaultDynamicValue(annotatedField.getName(), configuration, TypeLiteral.of((Type)targetType), propertyConverter, keys, loadPolicy, updatePolicy);
    }

    public static DynamicValue of(Method method, Configuration configuration) {
        return DefaultDynamicValue.of(method, configuration, LoadPolicy.ALWAYS, UpdatePolicy.IMMEDEATE);
    }

    public static DynamicValue of(Method method, Configuration configuration, UpdatePolicy updatePolicy) {
        return DefaultDynamicValue.of(method, configuration, LoadPolicy.ALWAYS, updatePolicy);
    }

    public static DynamicValue of(Method method, Configuration configuration, LoadPolicy loadPolicy) {
        return DefaultDynamicValue.of(method, configuration, loadPolicy, UpdatePolicy.IMMEDEATE);
    }

    public static DynamicValue of(Method method, Configuration configuration, LoadPolicy loadPolicy, UpdatePolicy updatePolicy) {
        Type targetType = method.getGenericReturnType();
        if (targetType == null) {
            throw new ConfigException("Failed to evaluate target type for " + method.getDeclaringClass().getName() + '.' + method.getName());
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)targetType;
            Type[] types = pt.getActualTypeArguments();
            if (types.length != 1) {
                throw new ConfigException("Failed to evaluate target type for " + method.getDeclaringClass().getName() + '.' + method.getName());
            }
            targetType = types[0];
        }
        PropertyConverter propertyConverter = null;
        WithPropertyConverter annot = method.getAnnotation(WithPropertyConverter.class);
        if (annot != null) {
            try {
                propertyConverter = (PropertyConverter)annot.value().newInstance();
            }
            catch (Exception e) {
                throw new ConfigException("Failed to instantiate annotated PropertyConverter on " + method.getDeclaringClass().getName() + '.' + method.getName(), (Throwable)e);
            }
        }
        return new DefaultDynamicValue(method.getName(), configuration, TypeLiteral.of((Type)targetType), propertyConverter, InjectionUtils.getKeys((Method)method), loadPolicy, updatePolicy);
    }

    public void commit() {
        T oldValue = this.value;
        this.value = this.newValue == null ? null : this.newValue[0];
        this.newValue = null;
        this.informListeners(oldValue, this.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informListeners(T value, T newValue) {
        DefaultDynamicValue defaultDynamicValue = this;
        synchronized (defaultDynamicValue) {
            PropertyChangeEvent evt = new PropertyChangeEvent((Object)this, this.propertyName, value, newValue);
            if (this.listeners != null) {
                for (PropertyChangeListener consumer : this.listeners.get()) {
                    consumer.propertyChange(evt);
                }
            }
        }
    }

    public void discard() {
        this.newValue = null;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setUpdatePolicy(UpdatePolicy updatePolicy) {
        this.updatePolicy = Objects.requireNonNull(updatePolicy);
    }

    public void addListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new WeakList();
        }
        this.listeners.add(l);
    }

    public void removeListener(PropertyChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public T get() {
        if (this.loadPolicy != LoadPolicy.INITIAL) {
            T newLocalValue = this.evaluateValue();
            if (this.value == null) {
                this.value = newLocalValue;
            }
            if (!Objects.equals(this.value, newLocalValue)) {
                switch (this.updatePolicy) {
                    case IMMEDEATE: {
                        this.commit();
                        break;
                    }
                    case EXPLCIT: {
                        this.newValue = new Object[]{newLocalValue};
                        break;
                    }
                    case LOG_ONLY: {
                        this.informListeners(this.value, newLocalValue);
                        this.newValue = null;
                        break;
                    }
                    case NEVER: {
                        this.newValue = null;
                        break;
                    }
                    default: {
                        this.newValue = null;
                    }
                }
            }
        }
        return this.value;
    }

    public boolean updateValue() {
        if (this.value == null && this.newValue == null) {
            this.value = this.evaluateValue();
            return false;
        }
        T newValue = this.evaluateValue();
        if (Objects.equals(newValue, this.value)) {
            return false;
        }
        switch (this.updatePolicy) {
            case LOG_ONLY: {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Discard change on " + (Object)((Object)this) + ", newValue=" + newValue);
                this.informListeners(this.value, newValue);
                this.newValue = null;
                break;
            }
            case NEVER: {
                this.newValue = null;
                break;
            }
            default: {
                this.newValue = new Object[]{newValue};
                this.commit();
            }
        }
        return true;
    }

    public T evaluateValue() {
        Object value = null;
        for (String key : this.keys) {
            if (this.propertyConverter == null) {
                value = this.configuration.get(key, this.targetType);
            } else {
                String source = this.configuration.get(key);
                ConversionContext ctx = new ConversionContext.Builder(this.configuration, this.configuration.getContext(), key, this.targetType).build();
                value = this.propertyConverter.convert(source, ctx);
            }
            if (value != null) break;
        }
        return (T)value;
    }

    public T getNewValue() {
        Object nv;
        Object object = nv = this.newValue == null ? null : this.newValue[0];
        if (nv != null) {
            return (T)nv;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.getUpdatePolicy());
        oos.writeObject(this.get());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.updatePolicy = (UpdatePolicy)ois.readObject();
        if (this.isPresent()) {
            this.value = ois.readObject();
        }
        this.newValue = null;
    }

    private class WeakList<I> {
        final List<WeakReference<I>> refs = new LinkedList<WeakReference<I>>();

        private WeakList() {
        }

        void add(I t) {
            this.refs.add(new WeakReference<I>(t));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(I t) {
            List<WeakReference<I>> list = this.refs;
            synchronized (list) {
                Iterator<WeakReference<I>> iterator = this.refs.iterator();
                while (iterator.hasNext()) {
                    WeakReference<I> ref = iterator.next();
                    Object instance = ref.get();
                    if (instance != null && instance != t) continue;
                    iterator.remove();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<I> get() {
            List<WeakReference<I>> list = this.refs;
            synchronized (list) {
                ArrayList res = new ArrayList();
                Iterator<WeakReference<I>> iterator = this.refs.iterator();
                while (iterator.hasNext()) {
                    WeakReference<I> ref = iterator.next();
                    Object instance = ref.get();
                    if (instance == null) {
                        iterator.remove();
                        continue;
                    }
                    res.add(instance);
                }
                return res;
            }
        }
    }
}

