/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;
import org.apache.tamaya.inject.api.DynamicValue;
import org.apache.tamaya.inject.api.WithConfigOperator;
import org.apache.tamaya.inject.api.WithPropertyConverter;
import org.apache.tamaya.integration.cdi.ConfigurationExtension;
import org.apache.tamaya.integration.cdi.DefaultDynamicValue;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

@ApplicationScoped
public class ConfigurationProducer {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationProducer.class.getName());

    private DynamicValue createynamicValue(InjectionPoint injectionPoint) {
        Member member = injectionPoint.getMember();
        if (member instanceof Field) {
            return DefaultDynamicValue.of((Field)member, ConfigurationProvider.getConfiguration());
        }
        if (member instanceof Method) {
            return DefaultDynamicValue.of((Method)member, ConfigurationProvider.getConfiguration());
        }
        return null;
    }

    @Produces
    @Config
    public Object resolveAndConvert(InjectionPoint injectionPoint) {
        if (DynamicValue.class.equals((Object)injectionPoint.getAnnotated().getBaseType())) {
            return this.createynamicValue(injectionPoint);
        }
        Config annotation = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
        ConfigDefaultSections typeAnnot = (ConfigDefaultSections)injectionPoint.getAnnotated().getAnnotation(ConfigDefaultSections.class);
        List<String> keys = ConfigurationExtension.evaluateKeys(injectionPoint.getMember().getName(), annotation != null ? annotation.value() : null, typeAnnot != null ? typeAnnot.value() : null);
        WithConfigOperator withOperatorAnnot = (WithConfigOperator)injectionPoint.getAnnotated().getAnnotation(WithConfigOperator.class);
        ConfigOperator operator = null;
        if (withOperatorAnnot != null) {
            operator = ConfigurationExtension.CUSTOM_OPERATORS.get(withOperatorAnnot.value());
        }
        PropertyConverter customCnverter = null;
        WithPropertyConverter withConverterAnnot = (WithPropertyConverter)injectionPoint.getAnnotated().getAnnotation(WithPropertyConverter.class);
        if (withConverterAnnot != null) {
            customCnverter = ConfigurationExtension.CUSTOM_CONVERTERS.get(withConverterAnnot.value());
        }
        Configuration config = ConfigurationProvider.getConfiguration();
        if (operator != null) {
            config = operator.operate(config);
        }
        Class toType = (Class)injectionPoint.getAnnotated().getBaseType();
        String textValue = null;
        String defaultTextValue = annotation.defaultValue().isEmpty() ? null : annotation.defaultValue();
        String keyFound = null;
        for (String key : keys) {
            textValue = config.get(key);
            if (textValue == null) continue;
            keyFound = key;
            break;
        }
        ConversionContext.Builder builder = new ConversionContext.Builder(config, ConfigurationProvider.getConfiguration().getContext(), keyFound, TypeLiteral.of((Type)toType));
        if (injectionPoint.getMember() instanceof AnnotatedElement) {
            builder.setAnnotatedElement((AnnotatedElement)((Object)injectionPoint.getMember()));
        }
        ConversionContext conversionContext = builder.build();
        Object value = null;
        if (keyFound != null) {
            if (customCnverter != null) {
                value = customCnverter.convert(textValue, conversionContext);
            }
            if (value == null) {
                value = config.get(keyFound, toType);
            }
        } else if (defaultTextValue != null) {
            if (customCnverter != null) {
                value = customCnverter.convert(defaultTextValue, conversionContext);
            }
            if (value == null) {
                List converters = ConfigurationProvider.getConfiguration().getContext().getPropertyConverters(TypeLiteral.of((Type)toType));
                for (PropertyConverter converter : converters) {
                    try {
                        value = converter.convert(defaultTextValue, conversionContext);
                        if (value == null) continue;
                        LOGGER.log(Level.FINEST, "Parsed default value from '" + defaultTextValue + "' into " + injectionPoint);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to convert default value '" + defaultTextValue + "' for " + injectionPoint, e);
                    }
                }
            }
        }
        if (value == null) {
            throw new ConfigException(String.format("Can't resolve any of the possible config keys: %s to the required target type: %s, supported formats: %s", keys.toString(), toType.getName(), conversionContext.getSupportedFormats().toString()));
        }
        LOGGER.finest(String.format("Injecting %s for key %s in class %s", keyFound, value.toString(), injectionPoint.toString()));
        return value;
    }
}

