/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;
import org.apache.tamaya.inject.api.WithConfigOperator;
import org.apache.tamaya.inject.api.WithPropertyConverter;
import org.apache.tamaya.integration.cdi.CDIConfiguredType;
import org.apache.tamaya.spi.PropertyConverter;

public class ConfigurationExtension
implements Extension {
    static final Map<Class, ConfigOperator> CUSTOM_OPERATORS = new ConcurrentHashMap<Class, ConfigOperator>();
    static final Map<Class, PropertyConverter> CUSTOM_CONVERTERS = new ConcurrentHashMap<Class, PropertyConverter>();
    private final Set<Type> types = new HashSet<Type>();
    private Bean<?> convBean;

    public void retrieveTypes(@Observes ProcessBean<?> pb, BeanManager beanManager) {
        Set ips = pb.getBean().getInjectionPoints();
        CDIConfiguredType configuredType = new CDIConfiguredType(pb.getBean().getBeanClass());
        boolean configured = false;
        for (InjectionPoint injectionPoint : ips) {
            String key;
            WithPropertyConverter withConverterAnnot;
            if (!injectionPoint.getAnnotated().isAnnotationPresent(Config.class)) continue;
            Config annotation = (Config)injectionPoint.getAnnotated().getAnnotation(Config.class);
            ConfigDefaultSections typeAnnot = (ConfigDefaultSections)injectionPoint.getAnnotated().getAnnotation(ConfigDefaultSections.class);
            List<String> keys = ConfigurationExtension.evaluateKeys(injectionPoint.getMember().getName(), annotation != null ? annotation.value() : null, typeAnnot != null ? typeAnnot.value() : null);
            WithConfigOperator withOperatorAnnot = (WithConfigOperator)injectionPoint.getAnnotated().getAnnotation(WithConfigOperator.class);
            if (withOperatorAnnot != null) {
                this.tryLoadOpererator(withOperatorAnnot.value());
            }
            if ((withConverterAnnot = (WithPropertyConverter)injectionPoint.getAnnotated().getAnnotation(WithPropertyConverter.class)) != null) {
                this.tryLoadConverter(withConverterAnnot.value());
            }
            Configuration config = ConfigurationProvider.getConfiguration();
            String value = null;
            Iterator<String> i$ = keys.iterator();
            while (i$.hasNext() && (value = config.get(key = i$.next())) == null) {
            }
            if (value == null && !annotation.defaultValue().isEmpty()) {
                value = annotation.defaultValue();
            }
            if (value == null) {
                throw new ConfigException(String.format("Cannot resolve any of the possible configuration keys: %s. Please provide one of the given keys with a value in your configuration sources.", keys.toString()));
            }
            this.types.add(injectionPoint.getType());
            if (annotation == null) continue;
            configured = true;
            configuredType.addConfiguredMember(injectionPoint, keys);
        }
        if (configured) {
            beanManager.fireEvent((Object)configuredType, new Annotation[0]);
        }
    }

    public void captureConvertBean(@Observes ProcessProducerMethod<?, ?> ppm) {
        if (ppm.getAnnotated().isAnnotationPresent(Config.class)) {
            this.convBean = ppm.getBean();
        }
    }

    public void addConverter(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        abd.addBean((Bean)new ConverterBean(this.convBean, this.types));
    }

    private void tryLoadOpererator(Class<? extends ConfigOperator> operatorClass) {
        Objects.requireNonNull(operatorClass);
        if (ConfigOperator.class == operatorClass) {
            return;
        }
        try {
            if (!CUSTOM_OPERATORS.containsKey(operatorClass)) {
                CUSTOM_OPERATORS.put(operatorClass, operatorClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new ConfigException("Custom ConfigOperator could not be loaded: " + operatorClass.getName(), (Throwable)e);
        }
    }

    private void tryLoadConverter(Class<? extends PropertyConverter> converterClass) {
        Objects.requireNonNull(converterClass);
        if (PropertyConverter.class == converterClass) {
            return;
        }
        try {
            if (!CUSTOM_CONVERTERS.containsKey(converterClass)) {
                CUSTOM_CONVERTERS.put(converterClass, converterClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new ConfigException("Custom PropertyConverter could not be loaded: " + converterClass.getName(), (Throwable)e);
        }
    }

    public static List<String> evaluateKeys(String memberName, String[] keys, String[] sections) {
        ArrayList<String> effKeys = new ArrayList<String>();
        if (keys != null) {
            effKeys.addAll(Arrays.asList(keys));
        }
        if (effKeys.isEmpty()) {
            effKeys.add(memberName);
        }
        ListIterator<String> iterator = effKeys.listIterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (next.startsWith("[") && next.endsWith("]")) {
                iterator.set(next.substring(1, next.length() - 1));
                continue;
            }
            if (sections == null || sections.length <= 0) continue;
            iterator.remove();
            for (String area : sections) {
                iterator.add(area.isEmpty() ? next : area + '.' + next);
            }
        }
        return effKeys;
    }

    private static class ConverterBean
    implements Bean<Object> {
        private final Bean<Object> delegate;
        private final Set<Type> types;

        public ConverterBean(Bean convBean, Set<Type> types) {
            this.types = types;
            this.delegate = convBean;
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Class<?> getBeanClass() {
            return this.delegate.getBeanClass();
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.delegate.getInjectionPoints();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Annotation> getQualifiers() {
            return this.delegate.getQualifiers();
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }

        public boolean isNullable() {
            return this.delegate.isNullable();
        }

        public Object create(CreationalContext<Object> creationalContext) {
            return this.delegate.create(creationalContext);
        }

        public void destroy(Object instance, CreationalContext<Object> creationalContext) {
            this.delegate.destroy(instance, creationalContext);
        }
    }
}

