/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.cdi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.inject.spi.ConfiguredField;

class CDIConfiguredField
implements ConfiguredField {
    private final Field field;
    private List<String> keys = new ArrayList<String>();

    CDIConfiguredField(InjectionPoint injectionPoint, List<String> keys) {
        this.field = (Field)injectionPoint.getMember();
        this.keys.addAll(keys);
        this.keys = Collections.unmodifiableList(this.keys);
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Collection<String> getConfiguredKeys() {
        return this.keys;
    }

    public Field getAnnotatedField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public String getSignature() {
        return this.getName() + ':' + this.field.getType().getName();
    }

    public void configure(Object instance, Configuration config) {
        throw new UnsupportedOperationException("Use CDI annotations for configuration injection.");
    }

    public String toString() {
        return "CDIConfiguredField[" + this.getSignature() + ']';
    }
}

