/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.inject.api;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.tamaya.inject.api.Config;
import org.apache.tamaya.inject.api.ConfigDefaultSections;

public final class InjectionUtils {
    private InjectionUtils() {
    }

    public static List<String> getKeys(Field field) {
        ConfigDefaultSections areasAnnot = field.getDeclaringClass().getAnnotation(ConfigDefaultSections.class);
        return InjectionUtils.evaluateKeys(field, areasAnnot, field.getAnnotation(Config.class));
    }

    public static List<String> getKeys(Method method) {
        ConfigDefaultSections areasAnnot = method.getDeclaringClass().getAnnotation(ConfigDefaultSections.class);
        return InjectionUtils.evaluateKeys(method, areasAnnot, method.getAnnotation(Config.class));
    }

    public static List<String> evaluateKeys(Member member, ConfigDefaultSections areasAnnot) {
        ArrayList<String> keys = new ArrayList<String>();
        String name = member.getName();
        String mainKey = name.startsWith("get") || name.startsWith("set") ? Character.toLowerCase(name.charAt(3)) + name.substring(4) : Character.toLowerCase(name.charAt(0)) + name.substring(1);
        keys.add(mainKey);
        if (areasAnnot != null) {
            for (String area : areasAnnot.value()) {
                if (area.isEmpty()) continue;
                keys.add(area + '.' + mainKey);
            }
        } else {
            keys.add(member.getDeclaringClass().getName() + '.' + mainKey);
        }
        return keys;
    }

    public static List<String> evaluateKeys(Member member, ConfigDefaultSections areasAnnot, Config propertyAnnotation) {
        if (propertyAnnotation == null) {
            return InjectionUtils.evaluateKeys(member, areasAnnot);
        }
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(propertyAnnotation.value()));
        if (keys.isEmpty()) {
            keys.add(member.getName());
        }
        ListIterator<String> iterator = keys.listIterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (next.startsWith("[") && next.endsWith("]")) {
                iterator.set(next.substring(1, next.length() - 1));
                continue;
            }
            if (areasAnnot == null || areasAnnot.value().length <= 0) continue;
            iterator.remove();
            for (String area : areasAnnot.value()) {
                iterator.add(area.isEmpty() ? next : area + '.' + next);
            }
        }
        return keys;
    }
}

