/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.etcd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.etcd.EtcdAccessor;
import org.apache.tamaya.etcd.EtcdBackends;
import org.apache.tamaya.mutableconfig.propertysources.AbstractMutablePropertySource;
import org.apache.tamaya.mutableconfig.propertysources.ConfigChangeContext;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueBuilder;

public class EtcdPropertySource
extends AbstractMutablePropertySource {
    private static final Logger LOG = Logger.getLogger(EtcdPropertySource.class.getName());
    private String prefix = System.getProperty("tamaya.etcd.prefix", "");
    private final boolean disabled = this.evaluateDisabled();

    private boolean evaluateDisabled() {
        String value = System.getProperty("tamaya.etcdprops.disable");
        if (value == null) {
            value = System.getenv("tamaya.etcdprops.disable");
        }
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public int getDefaultOrdinal() {
        return 1000;
    }

    public String getName() {
        return "etcd";
    }

    public PropertyValue get(String key) {
        if (this.disabled) {
            return null;
        }
        if (!key.startsWith(this.prefix)) {
            return null;
        }
        String reqKey = key = key.substring(this.prefix.length());
        if (key.startsWith("_")) {
            reqKey = key.substring(1);
            if (reqKey.endsWith(".createdIndex")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".createdIndex".length());
            } else if (reqKey.endsWith(".modifiedIndex")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".modifiedIndex".length());
            } else if (reqKey.endsWith(".ttl")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".ttl".length());
            } else if (reqKey.endsWith(".expiration")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".expiration".length());
            } else if (reqKey.endsWith(".source")) {
                reqKey = reqKey.substring(0, reqKey.length() - ".source".length());
            }
        }
        for (EtcdAccessor accessor : EtcdBackends.getEtcdBackends()) {
            try {
                Map<String, String> props = accessor.get(reqKey);
                if (!props.containsKey("_ERROR")) {
                    return new PropertyValueBuilder(key, props.get(reqKey), this.getName()).setContextData(props).build();
                }
                LOG.log(Level.FINE, "etcd error on " + accessor.getUrl() + ": " + props.get("_ERROR"));
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "etcd access failed on " + accessor.getUrl() + ", trying next...", e);
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        if (this.disabled) {
            return Collections.emptyMap();
        }
        if (!EtcdBackends.getEtcdBackends().isEmpty()) {
            for (EtcdAccessor accessor : EtcdBackends.getEtcdBackends()) {
                try {
                    Map<String, String> props = accessor.getProperties("");
                    if (!props.containsKey("_ERROR")) {
                        return this.mapPrefix(props);
                    }
                    LOG.log(Level.FINE, "etcd error on " + accessor.getUrl() + ": " + props.get("_ERROR"));
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "etcd access failed on " + accessor.getUrl() + ", trying next...", e);
                }
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, String> mapPrefix(Map<String, String> props) {
        if (this.prefix.isEmpty()) {
            return props;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (entry.getKey().startsWith("_")) {
                map.put("_" + this.prefix + entry.getKey().substring(1), entry.getValue());
                continue;
            }
            map.put(this.prefix + entry.getKey(), entry.getValue());
        }
        return map;
    }

    public boolean isScannable() {
        return true;
    }

    protected void commitInternal(ConfigChangeContext context) {
        for (EtcdAccessor accessor : EtcdBackends.getEtcdBackends()) {
            try {
                for (String string : context.getRemovedProperties()) {
                    Map<String, String> res = accessor.delete(string);
                    if (res.get("_ERROR") == null) continue;
                    LOG.info("Failed to remove key from etcd: " + string);
                }
                for (Map.Entry entry : context.getAddedProperties().entrySet()) {
                    Map<String, String> res;
                    String key = (String)entry.getKey();
                    Integer ttl = null;
                    int index = ((String)entry.getKey()).indexOf(63);
                    if (index > 0) {
                        String[] queries;
                        key = ((String)entry.getKey()).substring(0, index);
                        String rawQuery = ((String)entry.getKey()).substring(index + 1);
                        for (String query : queries = rawQuery.split("&")) {
                            if (!query.contains("ttl")) continue;
                            int qIdx = query.indexOf(61);
                            ttl = qIdx > 0 ? Integer.valueOf(Integer.parseInt(query.substring(qIdx + 1).trim())) : null;
                        }
                    }
                    if ((res = accessor.set(key, (String)entry.getValue(), ttl)).get("_ERROR") == null) continue;
                    LOG.info("Failed to add key to etcd: " + (String)entry.getKey() + "=" + (String)entry.getValue());
                }
                break;
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "etcd access failed on " + accessor.getUrl() + ", trying next...", e);
            }
        }
    }
}

