/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.propertysource;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;
import org.apache.tamaya.spi.PropertyValueBuilder;

public abstract class BasePropertySource
implements PropertySource {
    private final int defaultOrdinal;

    protected BasePropertySource(int defaultOrdinal) {
        this.defaultOrdinal = defaultOrdinal;
    }

    protected BasePropertySource() {
        this(0);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal.getValue(), e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public int getDefaultOrdinal() {
        return this.defaultOrdinal;
    }

    public PropertyValue get(String key) {
        Map properties = this.getProperties();
        String val = (String)properties.get(key);
        if (val == null) {
            return null;
        }
        PropertyValueBuilder b = new PropertyValueBuilder(key, val, this.getName());
        String metaKeyStart = "_" + key + ".";
        for (Map.Entry en : properties.entrySet()) {
            if (!((String)en.getKey()).startsWith(metaKeyStart) || en.getValue() == null) continue;
            b.addContextData(((String)en.getKey()).substring(metaKeyStart.length()), en.getValue());
        }
        return b.build();
    }

    public boolean isScannable() {
        return true;
    }
}

