/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class URLConverter
implements PropertyConverter<URL> {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());

    public URL convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), new String[]{"<URL>"});
        String trimmed = Objects.requireNonNull(value).trim();
        try {
            return new URL(trimmed);
        }
        catch (Exception e) {
            this.LOG.log(Level.FINE, "Unparseable URL: " + trimmed, e);
            return null;
        }
    }
}

