/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class CurrencyConverter
implements PropertyConverter<Currency> {
    private static final Logger LOG = Logger.getLogger(CurrencyConverter.class.getName());

    public Currency convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), new String[]{"<currencyCode>, using Locale.ENGLISH", "<numericValue>", "<locale>"});
        String trimmed = Objects.requireNonNull(value).trim();
        try {
            return Currency.getInstance(trimmed.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "Not a valid textual currency code: " + trimmed + ", checking for numeric...", e);
            try {
                Integer numCode = Integer.parseInt(trimmed);
                for (Currency currency : Currency.getAvailableCurrencies()) {
                    if (currency.getNumericCode() != numCode.intValue()) continue;
                    return currency;
                }
            }
            catch (Exception e2) {
                LOG.log(Level.FINEST, "Not a valid numeric currency code: " + trimmed + ", checking for locale...", e2);
            }
            try {
                Locale locale;
                String[] parts = trimmed.split("\\_");
                switch (parts.length) {
                    case 1: {
                        locale = new Locale("", parts[0]);
                        break;
                    }
                    case 2: {
                        locale = new Locale(parts[0], parts[1]);
                        break;
                    }
                    case 3: {
                        locale = new Locale(parts[0], parts[1], parts[2]);
                        break;
                    }
                    default: {
                        locale = null;
                    }
                }
                if (locale != null) {
                    return Currency.getInstance(locale);
                }
                LOG.finest("Not a valid currency: " + trimmed + ", giving up...");
            }
            catch (Exception e3) {
                LOG.log(Level.FINEST, "Not a valid country locale for currency: " + trimmed + ", giving up...", e3);
            }
            return null;
        }
    }
}

