/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.util.Objects;
import java.util.logging.Logger;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class CharConverter
implements PropertyConverter<Character> {
    private static final Logger LOG = Logger.getLogger(CharConverter.class.getName());

    public Character convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), new String[]{"\\'<char>\\'", "<char>", "<charNum>"});
        String trimmed = Objects.requireNonNull(value).trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.startsWith("'")) {
            try {
                trimmed = trimmed.substring(1, trimmed.length() - 1);
                if (trimmed.isEmpty()) {
                    return null;
                }
                return Character.valueOf(trimmed.charAt(0));
            }
            catch (Exception e) {
                LOG.finest("Invalid character format encountered: '" + value + "', valid formats are 'a', 101 and a.");
                return null;
            }
        }
        try {
            Integer val = Integer.parseInt(trimmed);
            return Character.valueOf((char)val.shortValue());
        }
        catch (Exception e) {
            LOG.finest("Character format is not numeric: '" + value + "', using first character.");
            return Character.valueOf(trimmed.charAt(0));
        }
    }
}

