/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal.converters;

import java.math.BigInteger;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.converters.ByteConverter;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;

public class BigIntegerConverter
implements PropertyConverter<BigInteger> {
    private static final Logger LOG = Logger.getLogger(BigIntegerConverter.class.getName());
    private final ByteConverter byteConverter = new ByteConverter();

    public BigInteger convert(String value, ConversionContext context) {
        context.addSupportedFormats(this.getClass(), new String[]{"[-]0X.. (hex)", "[-]0x... (hex)", "<bigint> -> new BigInteger(bigint)"});
        String trimmed = Objects.requireNonNull(value).trim();
        if (trimmed.startsWith("0x") || trimmed.startsWith("0X")) {
            LOG.finest("Parsing Hex value to BigInteger: " + value);
            trimmed = trimmed.substring(2);
            StringBuilder decimal = new StringBuilder();
            for (int offset = 0; offset < trimmed.length(); offset += 2) {
                if (offset == trimmed.length() - 1) {
                    LOG.finest("Invalid Hex-Byte-String: " + value);
                    return null;
                }
                byte val = this.byteConverter.convert("0x" + trimmed.substring(offset, offset + 2), context);
                if (val < 10) {
                    decimal.append('0').append(val);
                    continue;
                }
                decimal.append(val);
            }
            return new BigInteger(decimal.toString());
        }
        if (trimmed.startsWith("-0x") || trimmed.startsWith("-0X")) {
            LOG.finest("Parsing Hex value to BigInteger: " + value);
            trimmed = trimmed.substring(3);
            StringBuilder decimal = new StringBuilder();
            for (int offset = 0; offset < trimmed.length(); offset += 2) {
                if (offset == trimmed.length() - 1) {
                    LOG.finest("Invalid Hex-Byte-String: " + trimmed);
                    return null;
                }
                byte val = this.byteConverter.convert("0x" + trimmed.substring(offset, offset + 2), context);
                if (val < 10) {
                    decimal.append('0').append(val);
                    continue;
                }
                decimal.append(val);
            }
            return new BigInteger('-' + decimal.toString());
        }
        try {
            return new BigInteger(trimmed);
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "Failed to parse BigInteger from: " + value, e);
            return null;
        }
    }
}

