/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.core.internal.PriorityServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIServiceLoader
implements BundleListener {
    private static final Logger log = Logger.getLogger(OSGIServiceLoader.class.getName());
    private Map<Class, ServiceTracker<Object, Object>> services = new ConcurrentHashMap<Class, ServiceTracker<Object, Object>>();

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 2) {
            Bundle bundle = bundleEvent.getBundle();
            if (bundle.getEntry("META-INF/services/") == null) {
                return;
            }
            Enumeration entryPaths = bundle.getEntryPaths("META-INF/services/");
            while (entryPaths.hasMoreElements()) {
                String entryPath = (String)entryPaths.nextElement();
                if (entryPath.endsWith("/")) continue;
                this.processEntryPath(bundle, entryPath);
            }
        }
    }

    private void processEntryPath(Bundle bundle, String entryPath) {
        try {
            String serviceName = entryPath.substring("META-INF/services/".length());
            Class serviceClass = bundle.loadClass(serviceName);
            URL child = bundle.getEntry(entryPath);
            InputStream inStream = child.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            String implClassName = br.readLine();
            while (implClassName != null) {
                int hashIndex = implClassName.indexOf("#");
                if (hashIndex > 0) {
                    implClassName = implClassName.substring(0, hashIndex - 1);
                } else if (hashIndex == 0) {
                    implClassName = "";
                }
                implClassName = implClassName.trim();
                if (implClassName.length() > 0) {
                    try {
                        Class implClass = bundle.loadClass(implClassName);
                        if (!serviceClass.isAssignableFrom(implClass)) {
                            log.warning("Configured service: " + implClassName + " is not assignble to " + serviceClass.getName());
                            continue;
                        }
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        props.put("version", bundle.getVersion().toString());
                        String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
                        props.put("service.vendor", vendor != null ? vendor : "anonymous");
                        props.put("service.ranking", String.valueOf(PriorityServiceComparator.getPriority(implClass)));
                        JDKUtilServiceFactory factory = new JDKUtilServiceFactory(implClass);
                        BundleContext bundleContext = bundle.getBundleContext();
                        bundleContext.registerService(serviceName, (Object)factory, props);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Failed to load service class using ServiceLoader logic: " + implClassName, e);
                    }
                }
                implClassName = br.readLine();
            }
            br.close();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to read services from: " + entryPath, e);
        }
    }

    static class JDKUtilServiceFactory
    implements ServiceFactory {
        private final Class<?> serviceClass;

        public JDKUtilServiceFactory(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            try {
                return this.serviceClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Cannot instanciate service", ex);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

