/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.tamaya.core.internal.OSGIServiceComparator;
import org.apache.tamaya.spi.ServiceContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGIServiceContext
implements ServiceContext {
    private static final OSGIServiceComparator REF_COMPARATOR = new OSGIServiceComparator();
    private final BundleContext bundleContext;

    public OSGIServiceContext(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public boolean isInitialized() {
        return this.bundleContext != null;
    }

    public int ordinal() {
        return 10;
    }

    public <T> T getService(Class<T> serviceType) {
        ServiceReference ref = this.bundleContext.getServiceReference(serviceType);
        if (ref != null) {
            return (T)this.bundleContext.getService(ref);
        }
        return null;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        ArrayList refs = new ArrayList();
        try {
            refs.addAll(this.bundleContext.getServiceReferences(serviceType, null));
            Collections.sort(refs, REF_COMPARATOR);
            ArrayList<Object> services = new ArrayList<Object>(refs.size());
            for (ServiceReference ref : refs) {
                Object service = this.bundleContext.getService(ref);
                if (service == null) continue;
                services.add(service);
            }
            return services;
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

