/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.spi.ServiceContext;

public final class DefaultServiceContext
implements ServiceContext {
    private final ConcurrentHashMap<Class<?>, List<Object>> servicesLoaded = new ConcurrentHashMap();
    private final Map<Class<?>, Object> singletons = new ConcurrentHashMap();

    public <T> T getService(Class<T> serviceType) {
        List<T> services;
        Object cached = this.singletons.get(serviceType);
        if (cached == null && (cached = (services = this.getServices(serviceType)).isEmpty() ? null : this.getServiceWithHighestPriority(services, serviceType)) != null) {
            this.singletons.put(serviceType, cached);
        }
        return serviceType.cast(cached);
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        List<Object> found = this.servicesLoaded.get(serviceType);
        if (found != null) {
            return found;
        }
        List<T> services = new ArrayList();
        try {
            for (T t : ServiceLoader.load(serviceType)) {
                services.add(t);
            }
            services = Collections.unmodifiableList(services);
        }
        catch (Exception e) {
            Logger.getLogger(DefaultServiceContext.class.getName()).log(Level.WARNING, "Error loading services current type " + serviceType, e);
        }
        List<T> previousServices = (List<T>)List.class.cast(this.servicesLoaded.putIfAbsent(serviceType, services));
        return previousServices != null ? previousServices : services;
    }

    public static int getPriority(Object o) {
        int prio = 1;
        Priority priority = o.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            prio = priority.value();
        }
        return prio;
    }

    private <T> T getServiceWithHighestPriority(Collection<T> services, Class<T> serviceType) {
        if (services.size() == 1) {
            return services.iterator().next();
        }
        Integer highestPriority = null;
        int highestPriorityServiceCount = 0;
        T highestService = null;
        for (T service : services) {
            int prio = DefaultServiceContext.getPriority(service);
            if (highestPriority == null || highestPriority < prio) {
                highestService = service;
                highestPriorityServiceCount = 1;
                highestPriority = prio;
                continue;
            }
            if (highestPriority != prio) continue;
            ++highestPriorityServiceCount;
        }
        if (highestPriorityServiceCount > 1) {
            throw new ConfigException(MessageFormat.format("Found {0} implementations for Service {1} with Priority {2}: {3}", highestPriorityServiceCount, serviceType.getName(), highestPriority, services));
        }
        return highestService;
    }

    public int ordinal() {
        return 1;
    }
}

