/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.DefaultConfigurationContextBuilder;
import org.apache.tamaya.core.internal.PropertyConverterManager;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContextManager;

public class DefaultConfigurationContext
implements ConfigurationContext {
    private static final Logger LOG = Logger.getLogger(DefaultConfigurationContext.class.getName());
    private final PropertyConverterManager propertyConverterManager = new PropertyConverterManager();
    private List<PropertySource> immutablePropertySources;
    private List<PropertyFilter> immutablePropertyFilters;
    private PropertyValueCombinationPolicy propertyValueCombinationPolicy;
    private final ReentrantReadWriteLock propertySourceLock = new ReentrantReadWriteLock();
    private final PropertySourceComparator propertySourceComparator = new PropertySourceComparator();
    private final PropertyFilterComparator propertyFilterComparator = new PropertyFilterComparator();

    public DefaultConfigurationContext() {
        ArrayList<? extends PropertySource> propertySources = new ArrayList<PropertySource>();
        propertySources.addAll(ServiceContextManager.getServiceContext().getServices(PropertySource.class));
        propertySources.addAll(this.evaluatePropertySourcesFromProviders());
        Collections.sort(propertySources, new PropertySourceComparator());
        this.immutablePropertySources = Collections.unmodifiableList(propertySources);
        LOG.info("Registered " + this.immutablePropertySources.size() + " property sources: " + this.immutablePropertySources);
        ArrayList propertyFilters = new ArrayList();
        propertyFilters.addAll(ServiceContextManager.getServiceContext().getServices(PropertyFilter.class));
        Collections.sort(propertyFilters, new PropertyFilterComparator());
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info("Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.immutablePropertyFilters);
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info("Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.immutablePropertyFilters);
        this.propertyValueCombinationPolicy = (PropertyValueCombinationPolicy)ServiceContextManager.getServiceContext().getService(PropertyValueCombinationPolicy.class);
        if (this.propertyValueCombinationPolicy == null) {
            this.propertyValueCombinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        }
        LOG.info("Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    DefaultConfigurationContext(DefaultConfigurationContextBuilder builder) {
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>();
        propertySources.addAll(builder.propertySources.values());
        Collections.sort(propertySources, this.propertySourceComparator);
        this.immutablePropertySources = Collections.unmodifiableList(propertySources);
        LOG.info("Registered " + this.immutablePropertySources.size() + " property sources: " + this.immutablePropertySources);
        ArrayList propertyFilters = new ArrayList();
        propertyFilters.addAll(ServiceContextManager.getServiceContext().getServices(PropertyFilter.class));
        Collections.sort(propertyFilters, this.propertyFilterComparator);
        this.immutablePropertyFilters = Collections.unmodifiableList(propertyFilters);
        LOG.info("Registered " + this.immutablePropertyFilters.size() + " property filters: " + this.immutablePropertyFilters);
        this.propertyValueCombinationPolicy = builder.combinationPolicy;
        if (this.propertyValueCombinationPolicy == null) {
            this.propertyValueCombinationPolicy = (PropertyValueCombinationPolicy)ServiceContextManager.getServiceContext().getService(PropertyValueCombinationPolicy.class);
        }
        if (this.propertyValueCombinationPolicy == null) {
            this.propertyValueCombinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        }
        LOG.info("Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    private Collection<? extends PropertySource> evaluatePropertySourcesFromProviders() {
        ArrayList propertySources = new ArrayList();
        List propertySourceProviders = ServiceContextManager.getServiceContext().getServices(PropertySourceProvider.class);
        for (PropertySourceProvider propertySourceProvider : propertySourceProviders) {
            Collection sources = propertySourceProvider.getPropertySources();
            LOG.finer("PropertySourceProvider " + propertySourceProvider.getClass().getName() + " provided the following property sources: " + sources);
            propertySources.addAll(sources);
        }
        return propertySources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertySources(PropertySource ... propertySourcesToAdd) {
        ReentrantReadWriteLock.WriteLock writeLock = this.propertySourceLock.writeLock();
        try {
            writeLock.lock();
            ArrayList<PropertySource> newPropertySources = new ArrayList<PropertySource>(this.immutablePropertySources);
            newPropertySources.addAll(Arrays.asList(propertySourcesToAdd));
            Collections.sort(newPropertySources, new PropertySourceComparator());
            this.immutablePropertySources = Collections.unmodifiableList(newPropertySources);
        }
        finally {
            writeLock.unlock();
        }
    }

    public List<PropertySource> getPropertySources() {
        return this.immutablePropertySources;
    }

    public <T> void addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        this.propertyConverterManager.register(typeToConvert, propertyConverter);
        LOG.info("Added PropertyConverter: " + propertyConverter.getClass().getName());
    }

    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        return this.propertyConverterManager.getPropertyConverters();
    }

    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        return this.propertyConverterManager.getPropertyConverters(targetType);
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.immutablePropertyFilters;
    }

    public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
        return this.propertyValueCombinationPolicy;
    }

    public ConfigurationContextBuilder toBuilder() {
        return ConfigurationProvider.getConfigurationContextBuilder().setContext((ConfigurationContext)this);
    }

    private static class PropertyFilterComparator
    implements Comparator<PropertyFilter>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PropertyFilterComparator() {
        }

        private int comparePropertyFilters(PropertyFilter filter1, PropertyFilter filter2) {
            int ord2;
            Priority prio1 = filter1.getClass().getAnnotation(Priority.class);
            Priority prio2 = filter2.getClass().getAnnotation(Priority.class);
            int ord1 = prio1 != null ? prio1.value() : 0;
            int n = ord2 = prio2 != null ? prio2.value() : 0;
            if (ord1 < ord2) {
                return -1;
            }
            if (ord1 > ord2) {
                return 1;
            }
            return filter1.getClass().getName().compareTo(filter2.getClass().getName());
        }

        @Override
        public int compare(PropertyFilter filter1, PropertyFilter filter2) {
            return this.comparePropertyFilters(filter1, filter2);
        }
    }

    private static class PropertySourceComparator
    implements Comparator<PropertySource>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PropertySourceComparator() {
        }

        private int comparePropertySources(PropertySource source1, PropertySource source2) {
            if (source1.getOrdinal() < source2.getOrdinal()) {
                return -1;
            }
            if (source1.getOrdinal() > source2.getOrdinal()) {
                return 1;
            }
            return source1.getClass().getName().compareTo(source2.getClass().getName());
        }

        @Override
        public int compare(PropertySource source1, PropertySource source2) {
            return this.comparePropertySources(source1, source2);
        }
    }
}

