/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.ConfigOperator;
import org.apache.tamaya.ConfigQuery;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.core.internal.PropertyFiltering;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConversionContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;

public class DefaultConfiguration
implements Configuration {
    private static final Logger LOG = Logger.getLogger(DefaultConfiguration.class.getName());
    private final ConfigurationContext configurationContext;

    public DefaultConfiguration(ConfigurationContext configurationContext) {
        this.configurationContext = Objects.requireNonNull(configurationContext);
    }

    public String get(String key) {
        Map<String, String> value = this.evaluteRawValue(key);
        if (value == null || value.get(key) == null) {
            return null;
        }
        return PropertyFiltering.applyFilter(key, value, this.configurationContext);
    }

    protected Map<String, String> evaluteRawValue(String key) {
        List propertySources = this.configurationContext.getPropertySources();
        Map unfilteredValue = null;
        PropertyValueCombinationPolicy combinationPolicy = this.configurationContext.getPropertyValueCombinationPolicy();
        for (PropertySource propertySource : propertySources) {
            unfilteredValue = combinationPolicy.collect(unfilteredValue, key, propertySource);
        }
        return unfilteredValue;
    }

    public String getOrDefault(String key, String defaultValue) {
        String val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Map<String, String> getProperties() {
        return PropertyFiltering.applyFilters(this.evaluateUnfilteredMap(), this.configurationContext);
    }

    protected Map<String, String> evaluateUnfilteredMap() {
        ArrayList propertySources = new ArrayList(this.configurationContext.getPropertySources());
        Collections.reverse(propertySources);
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertySource propertySource : propertySources) {
            try {
                int origSize = result.size();
                Map otherMap = propertySource.getProperties();
                LOG.log(Level.FINEST, null, "Overriding with properties from " + propertySource.getName());
                result.putAll(otherMap);
                LOG.log(Level.FINEST, null, "Handled properties from " + propertySource.getName() + "(new: " + (result.size() - origSize) + ", overrides: " + origSize + ", total: " + result.size());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error adding properties from PropertySource: " + propertySource + ", ignoring PropertySource.", e);
            }
        }
        return result;
    }

    public <T> T get(String key, Class<T> type) {
        return this.get(key, TypeLiteral.of(type));
    }

    public <T> T get(String key, TypeLiteral<T> type) {
        return this.convertValue(key, this.get(key), type);
    }

    protected <T> T convertValue(String key, String value, TypeLiteral<T> type) {
        if (value != null) {
            List converters = this.configurationContext.getPropertyConverters(type);
            ConversionContext context = new ConversionContext.Builder((Configuration)this, this.configurationContext, key, type).build();
            for (PropertyConverter converter : converters) {
                try {
                    Object t = converter.convert(value, context);
                    if (t == null) continue;
                    return (T)t;
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "PropertyConverter: " + converter + " failed to convert value: " + value, e);
                }
            }
            throw new ConfigException("Unparseable config value for type: " + type.getRawType().getName() + ": " + key + ", supported formats: " + context.getSupportedFormats());
        }
        return null;
    }

    public <T> T getOrDefault(String key, TypeLiteral<T> type, T defaultValue) {
        T val = this.get(key, type);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Configuration with(ConfigOperator operator) {
        return operator.operate((Configuration)this);
    }

    public <T> T query(ConfigQuery<T> query) {
        return (T)query.query((Configuration)this);
    }

    public ConfigurationContext getContext() {
        return this.configurationContext;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

