/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tamaya.spi.FilterContext;
import org.apache.tamaya.spi.PropertyFilter;

public final class ProgrammableFilter
implements PropertyFilter {
    private List<PropertyFilter> filters = new ArrayList<PropertyFilter>();

    public void addFilter(PropertyFilter filter) {
        this.filters.add(filter);
    }

    public void addFilter(int pos, PropertyFilter filter) {
        this.filters.add(pos, filter);
    }

    public PropertyFilter removeFilter(int pos) {
        return this.filters.remove(pos);
    }

    public void removeFilter(PropertyFilter filter) {
        this.filters.remove(filter);
    }

    public void clearFilters() {
        this.filters.clear();
    }

    public void setFilters(PropertyFilter ... filters) {
        this.setFilters(Arrays.asList(filters));
    }

    public void setFilters(Collection<PropertyFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public List<PropertyFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public String filterProperty(String valueToBeFiltered, FilterContext context) {
        for (PropertyFilter filter : this.filters) {
            valueToBeFiltered = filter.filterProperty(valueToBeFiltered, context);
        }
        return valueToBeFiltered;
    }

    public String toString() {
        return "ProgrammableFilter{filters=" + this.filters + '}';
    }
}

