/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.filter;

import org.apache.tamaya.filter.ProgrammableFilter;
import org.apache.tamaya.spi.FilterContext;
import org.apache.tamaya.spi.PropertyFilter;

public final class ConfigurationFilter
implements PropertyFilter {
    static final ThreadLocal<Boolean> THREADED_METADATA_FILTERED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static final ThreadLocal<ProgrammableFilter> THREADED_MAP_FILTERS = new ThreadLocal<ProgrammableFilter>(){

        @Override
        protected ProgrammableFilter initialValue() {
            return new ProgrammableFilter();
        }
    };
    private static final ThreadLocal<ProgrammableFilter> THREADED_SINGLE_FILTERS = new ThreadLocal<ProgrammableFilter>(){

        @Override
        protected ProgrammableFilter initialValue() {
            return new ProgrammableFilter();
        }
    };

    public static boolean isMetadataFiltered() {
        return THREADED_METADATA_FILTERED.get();
    }

    public static void setMetadataFiltered(boolean filtered) {
        THREADED_METADATA_FILTERED.set(filtered);
    }

    public static ProgrammableFilter getSingleFilters() {
        return THREADED_SINGLE_FILTERS.get();
    }

    public static ProgrammableFilter getMapFilters() {
        return THREADED_MAP_FILTERS.get();
    }

    public static void clearFilters() {
        THREADED_MAP_FILTERS.get().clearFilters();
        THREADED_SINGLE_FILTERS.get().clearFilters();
        THREADED_METADATA_FILTERED.set(true);
    }

    public String filterProperty(String valueToBeFiltered, FilterContext context) {
        if (!context.isSinglePropertyScoped()) {
            for (PropertyFilter pred : THREADED_SINGLE_FILTERS.get().getFilters()) {
                valueToBeFiltered = pred.filterProperty(valueToBeFiltered, context);
            }
        } else {
            for (PropertyFilter pred : THREADED_MAP_FILTERS.get().getFilters()) {
                valueToBeFiltered = pred.filterProperty(valueToBeFiltered, context);
            }
        }
        return valueToBeFiltered;
    }
}

