/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.osgi;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.functions.ConfigurationFunctions;
import org.apache.tamaya.functions.PropertyMatcher;
import org.apache.tamaya.integration.osgi.OSGIConfigRootMapper;
import org.osgi.service.cm.ConfigurationAdmin;

public class TamayaConfigurationImpl
implements org.osgi.service.cm.Configuration {
    private static final Logger LOG = Logger.getLogger(TamayaConfigurationImpl.class.getName());
    private final String pid;
    private final String factoryPid;
    private Map<String, String> properties = new HashMap<String, String>();
    private Configuration config;

    public TamayaConfigurationImpl(String confPid, String factoryPid, OSGIConfigRootMapper configRootMapper, ConfigurationAdmin parent) {
        this.pid = confPid;
        this.factoryPid = factoryPid;
        if (parent != null) {
            try {
                Dictionary conf = parent.getConfiguration(confPid, factoryPid).getProperties();
                if (conf != null) {
                    LOG.info("Configuration: Adding default parameters from parent: " + parent.getClass().getName());
                    Enumeration keys = conf.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        this.properties.put(key, conf.get(key).toString());
                    }
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Error reading parent OSGI config.", e);
            }
        }
        this.config = ConfigurationProvider.getConfiguration();
        String rootKey = configRootMapper.getTamayaConfigRoot(this.pid, factoryPid);
        LOG.info("Configuration: Evaluating Tamaya configuration for '" + rootKey + "'.");
        this.properties.putAll(this.config.with(ConfigurationFunctions.section((String)rootKey, (boolean)true)).getProperties());
    }

    public String getPid() {
        return this.pid;
    }

    public Dictionary<String, Object> getProperties() {
        return new Hashtable<String, Object>(this.properties);
    }

    public void update(Dictionary<String, ?> properties) throws IOException {
        throw new UnsupportedOperationException("Nuatability not yet supported.");
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getFactoryPid() {
        return this.factoryPid;
    }

    public void update() throws IOException {
        this.config = ConfigurationProvider.getConfiguration();
        this.properties = this.config.with(ConfigurationFunctions.filter((PropertyMatcher)new PropertyMatcher(){

            public boolean test(String key, String value) {
                return false;
            }
        })).getProperties();
    }

    public void setBundleLocation(String location) {
    }

    public String getBundleLocation() {
        return null;
    }

    public long getChangeCount() {
        return 0L;
    }
}

