/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.integration.osgi.OSGIConfigRootMapper;
import org.apache.tamaya.integration.osgi.TamayaConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class TamayaConfigAdminImpl
implements ConfigurationAdmin {
    private static final Logger LOG = Logger.getLogger(TamayaConfigAdminImpl.class.getName());
    private final BundleContext context;
    private ConfigurationAdmin parent;
    private Map<String, Configuration> configs = new ConcurrentHashMap<String, Configuration>();
    private OSGIConfigRootMapper configRootMapper;

    protected OSGIConfigRootMapper loadConfigRootMapper() {
        OSGIConfigRootMapper mapper = null;
        ServiceReference ref = this.context.getServiceReference(OSGIConfigRootMapper.class);
        if (ref != null) {
            mapper = (OSGIConfigRootMapper)this.context.getService(ref);
        }
        if (mapper == null) {
            mapper = new OSGIConfigRootMapper(){

                @Override
                public String getTamayaConfigRoot(String pid, String factoryPid) {
                    if (pid != null) {
                        return "[bundle:" + pid + ']';
                    }
                    return "[bundle:" + factoryPid + ']';
                }

                public String toString() {
                    return "Default OSGIConfigRootMapper(pid -> [bundle:pid], factoryPid -> [bundle:factoryPid]";
                }
            };
        }
        return mapper;
    }

    public TamayaConfigAdminImpl(BundleContext context) {
        this.context = context;
        this.configRootMapper = this.loadConfigRootMapper();
        ServiceReference ref = context.getServiceReference(ConfigurationAdmin.class);
        this.parent = ref != null ? (ConfigurationAdmin)context.getService(ref) : null;
        ServiceTracker<ManagedService, ManagedService> serviceTracker = new ServiceTracker<ManagedService, ManagedService>(context, ManagedService.class, null){

            public ManagedService addingService(ServiceReference<ManagedService> reference) {
                ManagedService service;
                block5: {
                    service = (ManagedService)this.context.getService(reference);
                    Object pidObj = reference.getProperty("service.pid");
                    if (pidObj instanceof String) {
                        String pid = (String)pidObj;
                        try {
                            Configuration config = TamayaConfigAdminImpl.this.getConfiguration(pid);
                            if (config == null) {
                                service.updated(null);
                                break block5;
                            }
                            service.updated(config.getProperties());
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Error configuring ManagedService: " + service, e);
                        }
                    } else {
                        LOG.log(Level.SEVERE, "Unsupported pid: " + pidObj);
                    }
                }
                return service;
            }

            public void removedService(ServiceReference<ManagedService> reference, ManagedService service) {
                this.context.ungetService(reference);
            }
        };
        serviceTracker.open();
        ServiceTracker<ServiceFactory, ServiceFactory> factoryTracker = new ServiceTracker<ServiceFactory, ServiceFactory>(context, ServiceFactory.class, null){

            public ServiceFactory addingService(ServiceReference<ServiceFactory> reference) {
                ServiceFactory factory = (ServiceFactory)this.context.getService(reference);
                if (factory instanceof ManagedServiceFactory) {
                    Object pidObj = reference.getProperty("service.pid");
                    if (pidObj instanceof String) {
                        String pid = (String)pidObj;
                        try {
                            Configuration config = TamayaConfigAdminImpl.this.getConfiguration(pid);
                            if (config != null) {
                                ((ManagedServiceFactory)factory).updated(config.getFactoryPid(), config.getProperties());
                            }
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Error configuring ManagedServiceFactory: " + factory, e);
                        }
                    } else {
                        LOG.log(Level.SEVERE, "Unsupported pid: " + pidObj);
                    }
                }
                return factory;
            }

            public void removedService(ServiceReference<ServiceFactory> reference, ServiceFactory service) {
                super.removedService(reference, (Object)service);
            }
        };
        factoryTracker.open();
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        return this.createFactoryConfiguration(factoryPid, null);
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        return new TamayaConfigurationImpl(factoryPid, null, this.configRootMapper, this.parent);
    }

    public Configuration getConfiguration(String pid, String location) throws IOException {
        return this.getConfiguration(pid);
    }

    public Configuration getConfiguration(String pid) throws IOException {
        return new TamayaConfigurationImpl(pid, null, this.configRootMapper, this.parent);
    }

    public Configuration[] listConfigurations(String filter) throws IOException, InvalidSyntaxException {
        Collection<Configuration> result;
        if (filter == null) {
            result = this.configs.values();
        } else {
            result = new ArrayList<Configuration>();
            Filter flt = this.context.createFilter(filter);
            for (Configuration config : this.configs.values()) {
                if (!flt.match(config.getProperties())) continue;
                result.add(config);
            }
        }
        return result.isEmpty() ? null : result.toArray(new Configuration[this.configs.size()]);
    }
}

