/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.osgi;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spisupport.BasePropertySource;
import org.apache.tamaya.spisupport.DefaultConfiguration;
import org.apache.tamaya.spisupport.DefaultConfigurationContext;
import org.osgi.service.cm.Configuration;

public class OSGIEnhancedConfiguration
extends DefaultConfiguration {
    private static final int OSGI_DEFAULT_ORDINAL = 0;

    public OSGIEnhancedConfiguration(Configuration osgiConfiguration) {
        super((ConfigurationContext)new OSGIConfigurationContext(osgiConfiguration));
    }

    private static final class OSGIPropertySource
    extends BasePropertySource {
        private final Configuration osgiConfiguration;

        public OSGIPropertySource(Configuration osgiConfiguration) {
            this.osgiConfiguration = Objects.requireNonNull(osgiConfiguration);
        }

        public int getDefaultOrdinal() {
            String val = System.getProperty("osgi.defaultOrdinal");
            if (val != null) {
                return Integer.parseInt(val.trim());
            }
            return 0;
        }

        public String getName() {
            return "OSGIConfig:pid=" + (this.osgiConfiguration.getPid() != null ? this.osgiConfiguration.getPid() : this.osgiConfiguration.getFactoryPid());
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> map = new HashMap<String, String>();
            Dictionary dict = this.osgiConfiguration.getProperties();
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, String.valueOf(dict.get(key)));
            }
            return map;
        }
    }

    private static final class OSGIConfigurationContext
    extends DefaultConfigurationContext {
        private ConfigurationContext tamayaContext = ConfigurationProvider.getConfiguration().getContext();
        private OSGIPropertySource osgiPropertySource;

        public OSGIConfigurationContext(Configuration osgiConfiguration) {
            if (osgiConfiguration != null) {
                this.osgiPropertySource = new OSGIPropertySource(osgiConfiguration);
            }
        }

        public List<PropertySource> getPropertySources() {
            List sources = super.getPropertySources();
            if (this.osgiPropertySource != null) {
                sources.add(this.osgiPropertySource);
            }
            return sources;
        }
    }
}

