/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.integration.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.ConfigurationProvider;
import org.apache.tamaya.inject.ConfigurationInjection;
import org.apache.tamaya.integration.osgi.OSGIEnhancedConfiguration;
import org.apache.tamaya.integration.osgi.TamayaConfigAdminImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String SERVICE_RANKING_PROP = "org.tamaya.integration.osgi.cm.ranking";
    private static final String SERVICE_OVERRIDE_PROP = "org.tamaya.integration.osgi.cm.override";
    private static final String SERVICE_INJECT_PROP = "org.tamaya.integration.osgi.cm.inject";
    private static final Integer DEFAULT_RANKING = 10;
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private ServiceRegistration<ConfigurationAdmin> registration;
    private ServiceTracker<Object, Object> injectionTracker;

    public void start(BundleContext context) throws Exception {
        String val = context.getProperty(SERVICE_OVERRIDE_PROP);
        if (val == null || Boolean.parseBoolean(val)) {
            Hashtable<String, Integer> props = new Hashtable<String, Integer>();
            String ranking = context.getProperty(SERVICE_RANKING_PROP);
            if (ranking == null) {
                ((Dictionary)props).put("service.ranking", DEFAULT_RANKING);
            } else {
                ((Dictionary)props).put("service.ranking", Integer.valueOf(ranking));
            }
            TamayaConfigAdminImpl cm = new TamayaConfigAdminImpl(context);
            this.registration = context.registerService(ConfigurationAdmin.class, (Object)cm, props);
        }
        if ((val = context.getProperty(SERVICE_INJECT_PROP)) == null || Boolean.parseBoolean(val)) {
            this.injectionTracker = new ServiceTracker<Object, Object>(context, Object.class, null){

                public Object addingService(ServiceReference<Object> reference) {
                    Object service = this.context.getService(reference);
                    Object pidObj = reference.getProperty("service.pid");
                    if (pidObj instanceof String) {
                        String pid = (String)pidObj;
                        ConfigurationAdmin configAdmin = null;
                        ServiceReference adminRef = this.context.getServiceReference(ConfigurationAdmin.class);
                        if (adminRef != null) {
                            configAdmin = (ConfigurationAdmin)this.context.getService(adminRef);
                        }
                        try {
                            Configuration osgiConfig;
                            Object targetConfig = null;
                            if (configAdmin != null && (osgiConfig = configAdmin.getConfiguration(pid)) != null) {
                                targetConfig = new OSGIEnhancedConfiguration(osgiConfig);
                            }
                            if (targetConfig == null) {
                                targetConfig = ConfigurationProvider.getConfiguration();
                            }
                            ConfigurationInjection.getConfigurationInjector().configure(service, targetConfig);
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Error configuring Service: " + service, e);
                        }
                    } else {
                        LOG.log(Level.SEVERE, "Unsupported pid: " + pidObj);
                    }
                    return service;
                }

                public void removedService(ServiceReference<Object> reference, Object service) {
                    this.context.ungetService(reference);
                }
            };
            this.injectionTracker.open();
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.injectionTracker != null) {
            this.injectionTracker.close();
        }
    }
}

