/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertyValue;

public class SimplePropertySource
implements PropertySource {
    private final Map<String, String> properties;
    private final String name;

    public SimplePropertySource(String name, Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
        this.name = Objects.requireNonNull(name);
    }

    public int getOrdinal() {
        PropertyValue configuredOrdinal = this.get("tamaya.ordinal");
        if (configuredOrdinal != null) {
            try {
                return Integer.parseInt(configuredOrdinal.getValue());
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Configured Ordinal is not an int number: " + configuredOrdinal, e);
            }
        }
        return this.getDefaultOrdinal();
    }

    public int getDefaultOrdinal() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public PropertyValue get(String key) {
        return null;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isScannable() {
        return false;
    }

    public String toString() {
        return "SimplePropertySource(name=" + this.name + ", numProps=" + this.properties.size() + ")";
    }
}

