/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.annotation.Priority;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.ConfigurationContextBuilder;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spi.ServiceContextManager;
import org.apache.tamaya.spisupport.PriorityServiceComparator;
import org.apache.tamaya.spisupport.PropertyConverterManager;
import org.apache.tamaya.spisupport.PropertySourceComparator;

class ProgrammaticConfigurationContext
implements ConfigurationContext {
    private static final Comparator<PropertySource> PS_COMPARATOR = new PropertySourceComparator();
    private static final Comparator<Object> COMP_COMPARATOR = new PriorityServiceComparator();
    private static final Logger LOG = Logger.getLogger(ProgrammaticConfigurationContext.class.getName());
    private PropertyConverterManager propertyConverterManager = new PropertyConverterManager();
    private List<PropertySource> immutablePropertySources = new ArrayList<PropertySource>();
    private List<PropertyFilter> immutablePropertyFilters = new ArrayList<PropertyFilter>();
    private PropertyValueCombinationPolicy propertyValueCombinationPolicy;
    private final ReadWriteLock propertySourceLock = new ReentrantReadWriteLock();

    public ProgrammaticConfigurationContext(Builder builder) {
        this.propertyConverterManager = new PropertyConverterManager(builder.loadProvidedPropertyConverters);
        List<PropertySource> sources = this.getAllPropertySources(builder);
        Collections.sort(sources, PS_COMPARATOR);
        this.immutablePropertySources = Collections.unmodifiableList(sources);
        List<PropertyFilter> filters = this.getPropertyFilters(builder);
        Collections.sort(filters, COMP_COMPARATOR);
        this.immutablePropertyFilters = Collections.unmodifiableList(filters);
        this.propertyValueCombinationPolicy = builder.propertyValueCombinationPolicy;
        for (Map.Entry en : builder.propertyConverters.entrySet()) {
            if (en == null) continue;
            for (PropertyConverter pv : (List)en.getValue()) {
                this.propertyConverterManager.register((TypeLiteral)en.getKey(), pv);
            }
        }
        LOG.info("Using " + this.immutablePropertySources.size() + " property sources: " + this.immutablePropertySources);
        LOG.info("Using " + this.immutablePropertyFilters.size() + " property filters: " + this.immutablePropertyFilters);
        LOG.info("Using PropertyValueCombinationPolicy: " + this.propertyValueCombinationPolicy);
    }

    private List<PropertyFilter> getPropertyFilters(Builder builder) {
        ArrayList<PropertyFilter> provided = new ArrayList<PropertyFilter>();
        if (builder.loadProvidedPropertyFilters) {
            provided.addAll(ServiceContextManager.getServiceContext().getServices(PropertyFilter.class));
        }
        for (PropertyFilter pf : builder.propertyFilters) {
            if (pf == null) continue;
            provided.add(pf);
        }
        return provided;
    }

    private List<PropertySource> getAllPropertySources(Builder builder) {
        ArrayList<PropertySource> provided = new ArrayList<PropertySource>();
        if (builder.loadProvidedPropertySources) {
            provided.addAll(ServiceContextManager.getServiceContext().getServices(PropertySource.class));
        }
        for (PropertySource ps : builder.propertySources) {
            if (ps == null) continue;
            provided.add(ps);
        }
        if (builder.loadProvidedPropertySourceProviders) {
            List providers = ServiceContextManager.getServiceContext().getServices(PropertySourceProvider.class);
            for (PropertySourceProvider provider : providers) {
                for (PropertySource ps : provider.getPropertySources()) {
                    if (ps == null) continue;
                    provided.addAll(provider.getPropertySources());
                }
            }
        }
        return provided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertySources(PropertySource ... propertySourcesToAdd) {
        Lock writeLock = this.propertySourceLock.writeLock();
        try {
            writeLock.lock();
            ArrayList<PropertySource> provided = new ArrayList<PropertySource>();
            for (PropertySource ps : propertySourcesToAdd) {
                if (ps == null) continue;
                provided.add(ps);
            }
            this.immutablePropertySources = Collections.unmodifiableList(provided);
        }
        finally {
            writeLock.unlock();
        }
    }

    private int comparePropertySources(PropertySource source1, PropertySource source2) {
        if (source1.getOrdinal() < source2.getOrdinal()) {
            return -1;
        }
        if (source1.getOrdinal() > source2.getOrdinal()) {
            return 1;
        }
        return source1.getClass().getName().compareTo(source2.getClass().getName());
    }

    private int comparePropertyFilters(PropertyFilter filter1, PropertyFilter filter2) {
        int ord2;
        Priority prio1 = filter1.getClass().getAnnotation(Priority.class);
        Priority prio2 = filter2.getClass().getAnnotation(Priority.class);
        int ord1 = prio1 != null ? prio1.value() : 0;
        int n = ord2 = prio2 != null ? prio2.value() : 0;
        if (ord1 < ord2) {
            return -1;
        }
        if (ord1 > ord2) {
            return 1;
        }
        return filter1.getClass().getName().compareTo(filter2.getClass().getName());
    }

    public List<PropertySource> getPropertySources() {
        return this.immutablePropertySources;
    }

    public <T> void addPropertyConverter(TypeLiteral<T> typeToConvert, PropertyConverter<T> propertyConverter) {
        this.propertyConverterManager.register(typeToConvert, propertyConverter);
        LOG.info("Added PropertyConverter: " + propertyConverter.getClass().getName());
    }

    public Map<TypeLiteral<?>, List<PropertyConverter<?>>> getPropertyConverters() {
        return this.propertyConverterManager.getPropertyConverters();
    }

    public <T> List<PropertyConverter<T>> getPropertyConverters(TypeLiteral<T> targetType) {
        return this.propertyConverterManager.getPropertyConverters(targetType);
    }

    public List<PropertyFilter> getPropertyFilters() {
        return this.immutablePropertyFilters;
    }

    public PropertyValueCombinationPolicy getPropertyValueCombinationPolicy() {
        return this.propertyValueCombinationPolicy;
    }

    public ConfigurationContextBuilder toBuilder() {
        throw new RuntimeException("This method is currently not supported.");
    }

    public static final class Builder {
        private final List<PropertySource> propertySources = new ArrayList<PropertySource>();
        private final List<PropertyFilter> propertyFilters = new ArrayList<PropertyFilter>();
        private final Map<TypeLiteral<?>, List<PropertyConverter<?>>> propertyConverters = new HashMap();
        private PropertyValueCombinationPolicy propertyValueCombinationPolicy = PropertyValueCombinationPolicy.DEFAULT_OVERRIDING_COLLECTOR;
        private boolean loadProvidedPropertyConverters;
        private boolean loadProvidedPropertySources;
        private boolean loadProvidedPropertySourceProviders;
        private boolean loadProvidedPropertyFilters;

        public Builder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy policy) {
            this.propertyValueCombinationPolicy = Objects.requireNonNull(policy);
            return this;
        }

        public Builder addPropertySources(PropertySource ... propertySources) {
            for (PropertySource ps : propertySources) {
                if (ps == null) continue;
                this.propertySources.add(ps);
            }
            return this;
        }

        public Builder addPropertySources(Collection<PropertySource> propertySources) {
            for (PropertySource ps : propertySources) {
                if (ps == null) continue;
                this.propertySources.add(ps);
            }
            return this;
        }

        public Builder addPropertySourceProviders(PropertySourceProvider ... propertySourceProviders) {
            for (PropertySourceProvider ps : propertySourceProviders) {
                if (ps == null) continue;
                this.propertySources.addAll(ps.getPropertySources());
            }
            return this;
        }

        public Builder addPropertySourceProviders(Collection<PropertySourceProvider> propertySourceProviders) {
            for (PropertySourceProvider ps : propertySourceProviders) {
                if (ps == null) continue;
                this.propertySources.addAll(ps.getPropertySources());
            }
            return this;
        }

        public Builder addPropertyFilters(PropertyFilter ... propertyFIlter) {
            for (PropertyFilter pf : propertyFIlter) {
                if (pf == null) continue;
                this.propertyFilters.add(pf);
            }
            return this;
        }

        public Builder addPropertyFilters(Collection<PropertyFilter> propertyFIlter) {
            for (PropertyFilter pf : propertyFIlter) {
                if (pf == null) continue;
                this.propertyFilters.add(pf);
            }
            return this;
        }

        @Deprecated
        public Builder setConfigurationContext(ConfigurationContext configurationContext) {
            this.addPropertySources(configurationContext.getPropertySources());
            this.addPropertyFilters(configurationContext.getPropertyFilters());
            this.propertyValueCombinationPolicy = Objects.requireNonNull(configurationContext.getPropertyValueCombinationPolicy());
            return this;
        }

        public <T> Builder addPropertyConverter(TypeLiteral<T> type, PropertyConverter<T> propertyConverter) {
            if (!this.propertyConverters.containsKey(type)) {
                ArrayList<PropertyConverter<T>> convList = new ArrayList<PropertyConverter<T>>();
                convList.add(propertyConverter);
                this.propertyConverters.put(type, convList);
            }
            return this;
        }

        public ConfigurationContext build() {
            return new ProgrammaticConfigurationContext(this);
        }

        public void loadProvidedPropertyConverters(boolean state) {
            this.loadProvidedPropertyConverters = state;
        }

        public void loadProvidedPropertySources(boolean state) {
            this.loadProvidedPropertySources = state;
        }

        public void loadProvidedPropertySourceProviders(boolean state) {
            this.loadProvidedPropertySourceProviders = state;
        }

        public void loadProvidedPropertyFilters(boolean state) {
            this.loadProvidedPropertyFilters = state;
        }
    }
}

