/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tamaya.builder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import org.apache.tamaya.ConfigException;
import org.apache.tamaya.Configuration;
import org.apache.tamaya.TypeLiteral;
import org.apache.tamaya.builder.ProgrammaticConfigurationContext;
import org.apache.tamaya.format.ConfigurationData;
import org.apache.tamaya.format.ConfigurationFormats;
import org.apache.tamaya.format.FlattenedDefaultPropertySource;
import org.apache.tamaya.spi.ConfigurationContext;
import org.apache.tamaya.spi.PropertyConverter;
import org.apache.tamaya.spi.PropertyFilter;
import org.apache.tamaya.spi.PropertySource;
import org.apache.tamaya.spi.PropertySourceProvider;
import org.apache.tamaya.spi.PropertyValueCombinationPolicy;
import org.apache.tamaya.spisupport.DefaultConfiguration;

public class ConfigurationBuilder {
    private final ProgrammaticConfigurationContext.Builder contextBuilder = new ProgrammaticConfigurationContext.Builder();
    private boolean built;
    private boolean loadProvidedPropertyConverters = true;
    private boolean loadProvidedPropertySources = false;
    private boolean loadProvidedPropertySourceProviders = false;
    private boolean isLoadProvidedPropertyFilters = false;

    ConfigurationBuilder setConfigurationContext(ConfigurationContext configurationContext) {
        this.contextBuilder.setConfigurationContext(configurationContext);
        return this;
    }

    public ConfigurationBuilder addPropertySource(URL url) {
        try {
            ConfigurationData data = this.getConfigurationDataFromURL(url);
            FlattenedDefaultPropertySource propertySource = new FlattenedDefaultPropertySource(data);
            this.addPropertySources(new PropertySource[]{propertySource});
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read " + url.toString(), (Throwable)e);
        }
        return this;
    }

    protected ConfigurationData getConfigurationDataFromURL(URL url) throws IOException {
        ConfigurationData data = ConfigurationFormats.readConfigurationData((URL)url);
        if (null == data) {
            String mesg = String.format("No configuration format found which is able to read properties from %s.", url.toString());
            throw new ConfigException(mesg);
        }
        return data;
    }

    public ConfigurationBuilder addPropertySources(URL ... urls) {
        for (URL url : urls) {
            if (url == null) continue;
            this.addPropertySource(url);
        }
        return this;
    }

    public ConfigurationBuilder addPropertySources(Collection<URL> urls) {
        for (URL url : urls) {
            if (url == null) continue;
            this.addPropertySource(url);
        }
        return this;
    }

    public ConfigurationBuilder addPropertySources(String ... urls) {
        for (String url : urls) {
            if (url == null) continue;
            try {
                this.addPropertySource(new URL(url));
            }
            catch (Exception e) {
                throw new ConfigException("Invalid URL: " + url);
            }
        }
        return this;
    }

    public ConfigurationBuilder addPropertySources(PropertySource ... sources) {
        this.checkBuilderState();
        this.contextBuilder.addPropertySources(Objects.requireNonNull(sources));
        return this;
    }

    private void checkBuilderState() {
        if (this.built) {
            throw new IllegalStateException("Configuration has already been build.");
        }
    }

    public ConfigurationBuilder addPropertySourceProviders(PropertySourceProvider ... providers) {
        this.contextBuilder.addPropertySourceProviders(providers);
        return this;
    }

    public ConfigurationBuilder addPropertyFilters(PropertyFilter ... filters) {
        Objects.requireNonNull(filters);
        this.contextBuilder.addPropertyFilters(filters);
        return this;
    }

    public ConfigurationBuilder setPropertyValueCombinationPolicy(PropertyValueCombinationPolicy propertyValueCombinationPolicy) {
        this.contextBuilder.setPropertyValueCombinationPolicy(propertyValueCombinationPolicy);
        return this;
    }

    public <T> ConfigurationBuilder addPropertyConverter(Class<T> type, PropertyConverter<T> converter) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(converter);
        return this.addPropertyConverter(TypeLiteral.of(type), converter);
    }

    public <T> ConfigurationBuilder addPropertyConverter(TypeLiteral<T> type, PropertyConverter<T> propertyConverter) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(propertyConverter);
        this.contextBuilder.addPropertyConverter(type, propertyConverter);
        return this;
    }

    public boolean isPropertyConverterLoadingEnabled() {
        return this.loadProvidedPropertyConverters;
    }

    public ConfigurationBuilder enableProvidedPropertyConverters() {
        this.checkBuilderState();
        this.loadProvidedPropertyConverters = true;
        return this;
    }

    public ConfigurationBuilder disableProvidedPropertyConverters() {
        this.checkBuilderState();
        this.loadProvidedPropertyConverters = false;
        return this;
    }

    public ConfigurationBuilder enableProvidedPropertySources() {
        this.checkBuilderState();
        this.loadProvidedPropertySources = true;
        return this;
    }

    public boolean isPropertySourcesLoadingEnabled() {
        return this.loadProvidedPropertySources;
    }

    public boolean isPropertyFilterLoadingEnabled() {
        return this.isLoadProvidedPropertyFilters;
    }

    public ConfigurationBuilder enabledProvidedPropertyFilters() {
        this.checkBuilderState();
        this.isLoadProvidedPropertyFilters = true;
        return this;
    }

    public ConfigurationBuilder disableProvidedPropertyFilters() {
        this.checkBuilderState();
        this.isLoadProvidedPropertyFilters = false;
        return this;
    }

    public ConfigurationBuilder disableProvidedPropertySources() {
        this.checkBuilderState();
        this.loadProvidedPropertySources = false;
        return this;
    }

    public ConfigurationBuilder enableProvidedPropertySourceProviders() {
        this.checkBuilderState();
        this.loadProvidedPropertySourceProviders = true;
        return this;
    }

    public ConfigurationBuilder disableProvidedPropertySourceProviders() {
        this.checkBuilderState();
        this.loadProvidedPropertySourceProviders = false;
        return this;
    }

    public boolean isPropertySourceProvidersLoadingEnabled() {
        return this.loadProvidedPropertySourceProviders;
    }

    public Configuration build() {
        this.checkBuilderState();
        this.built = true;
        this.contextBuilder.loadProvidedPropertyConverters(this.isPropertyConverterLoadingEnabled());
        this.contextBuilder.loadProvidedPropertySources(this.isPropertySourcesLoadingEnabled());
        this.contextBuilder.loadProvidedPropertySourceProviders(this.isPropertySourceProvidersLoadingEnabled());
        this.contextBuilder.loadProvidedPropertyFilters(this.isLoadProvidedPropertyFilters);
        return new DefaultConfiguration(this.contextBuilder.build());
    }

    private static class StringToURLMapper {
        private StringToURLMapper() {
        }

        public URL apply(String u) {
            try {
                return new URL(u);
            }
            catch (MalformedURLException e) {
                throw new ConfigException(u + " is not a valid URL", (Throwable)e);
            }
        }
    }
}

